<?php
// Get custom field values
$featured_story_title = get_field('featured_story_title', ) ?: 'TEXT EFFECT';
$featured_story_overlay = get_field('featured_story_overlay',) ?: 'WOAH';
$featured_video_url = get_field('featured_video_url', ) ?: 'https://assets.codepen.io/319606/tactus-waves-hero-sm.mp4';

// Get featured stories
$hero_story = get_field('hero_story', );
$featured_stories = get_field('featured_stories', );
?>

<style>
/* Your existing CSS styles here */
.featurd-story {
  background-color: #212121;
  border-bottom-right-radius: 15vw;
  position: relative;
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
  border-top-right-radius: 15vw;
}

.featurd-story:before {
  content: "";
  background-color: #212121;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
}

.featurd-story:after {
  content: "";
  background-color: #fff;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
  border-top-left-radius: 15vw;
}

.featured-video-wrap {
  position: absolute;
  width: 100%;
  height: 100%;
  overflow: hidden;
  border-bottom-right-radius: 15vw;
  border-top-right-radius: 15vw;
  pointer-events: none;
}

#featured-video-bg {
  position: absolute;
  width: 100%;
  height: 100%;
  min-width: 100%;
  background-position: center center;
  background-size: cover;
  object-fit: cover;
  opacity: 0.7;
}

.featured-gradient-overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: linear-gradient(to bottom, rgba(33,33,33,0.2) 0%, rgba(33,33,33,0.9) 100%);
  z-index: 1;
  border-bottom-right-radius: 15vw;
  border-top-right-radius: 15vw;
  pointer-events: none;
}

.featurd-story-sec {
  max-width: 1320px;
  margin: 0 auto;
  position: relative;
  z-index: 2;
}

.animated-text-new {
  font-size: 7vw;
  letter-spacing: -.01em;
  line-height: 100%;
  margin: 0;
  width: 100%;
  color: rgb(161 146 146);
  background: linear-gradient(to right, #e50914, #e50914) no-repeat;
  -webkit-background-clip: text;
  background-clip: text;
  background-size: 0%;
  transition: background-size cubic-bezier(.1,.5,.5,1) 0.5s;
  border-bottom: 1px solid #2F2B28;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  position: relative;
  cursor: pointer;
  padding: 0.5rem 0;
}

.animated-text-new:hover > .text-overlay {
  clip-path: polygon(0 0, 100% 0, 100% 100%, 0% 100%);
}

/* Card Custom Styles */
.card-custome {
  display: flex;
  flex-direction: column;
  height: 100%;
  color: #dee2e6;
  text-decoration: none;
  background-color: rgba(255, 255, 255, 0.15);
  border-radius: 14px;
  min-height: 360px;
  overflow: hidden;
  transition: transform 0.3s ease;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
}

.card-custome:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}

.card-custome .visual-custome {
  overflow: hidden;
  flex-shrink: 0;
}

.card-custome .visual-custome img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  transition: transform 0.4s ease;
}

.card-custome .content-custome {
  padding: 1.5rem;
  display: flex;
  flex-direction: column;
  height: 100%;
}

.card-custome.hero-custome {
  min-height: 540px; 
}

.card-custome.hero-custome .visual-custome {
  height: 50%;
}

.card-custome:not(.hero-custome) .visual-custome {
  height: 50%;
}

.card-custome h1, 
.card-custome h3 {
  font-weight: 700;
}

.card-custome small {
  font-weight: 600;
  color: #dee2e6;
}

/* Animation */
@media (prefers-reduced-motion: no-preference) {
  .card-custome:hover img {
    transform: scale(1.03);
  }
}

/* Reveal animation */
@media (prefers-reduced-motion: no-preference) {
  .card-custome:not(.hero-custome) {
    opacity: 0;
    transform: translateY(100px);
    transition: opacity 0.66s ease, transform 1s cubic-bezier(0,0,0.1,1);
  }
  .reveal-custome {
    opacity: 1 !important;
    transform: translateY(0) !important;
  }
}

/* Responsive adjustments */
@media (min-width: 768px) {
  .card-custome.hero-custome {
    flex-direction: row;
  }
  
  .card-custome.hero-custome .visual-custome,
  .card-custome.hero-custome .content-custome {
    width: 50%;
    height: 100%;
  }
  
  .hero-content {
    padding: 2rem;
  }
}

@media (min-width: 1024px) {
  .card-custome.hero-custome {
    min-height: 540px;
  }
  
  .tall-card {
    min-height: 450px; /* 360px * 1.25 */
  }
}
</style>

<section class="featurd-story">
  <!-- Video Background for Featured Story Section -->
  <div class="featured-video-wrap">
    <video autoplay playsinline loop muted id="featured-video-bg">
      <source src="<?php echo esc_url($featured_video_url); ?>" type="video/mp4">
    </video>
  </div>
  <div class="position-absolute w-100 featured-gradient-overlay"></div>
  
  <div class="featurd-story-sec container py-5">
    <h1 class="animated-text-new mb-4" data-aos="fade-up" data-aos-duration="800">
      <?php echo esc_html($featured_story_title); ?>
      <span class="text-overlay"><?php echo esc_html($featured_story_overlay); ?></span>
    </h1>
    
    <div class="row g-4">
      <?php if ($hero_story): ?>
      <div class="col-12" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
        <a href="<?php echo esc_url($hero_story['link']); ?>" class="card-custome hero-custome">
          <div class="visual-custome">
            <?php if ($hero_story['image']): ?>
            <picture>
              <img src="<?php echo esc_url($hero_story['image']); ?>" 
                   alt="<?php echo esc_attr($hero_story['title']); ?>" 
                   width="512" height="512" loading="lazy" />
            </picture>
            <?php endif; ?>
          </div>
          <div class="content-custome justify-content-center hero-content">
            <small class="mb-2"><?php echo esc_html($hero_story['category'] ?: 'FEATURED STORY'); ?></small>
            <h1 class="mb-3"><?php echo esc_html($hero_story['title']); ?></h1>
            <small><?php echo esc_html($hero_story['date']); ?></small>
          </div>
        </a>
      </div>
      <?php endif; ?>

      <?php if ($featured_stories): ?>
        <?php foreach ($featured_stories as $index => $story): ?>
        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-duration="800" data-aos-delay="<?php echo 300 + ($index * 100); ?>">
          <a href="<?php echo esc_url($story['link']); ?>" class="card-custome tall-card">
            <div class="visual-custome">
              <?php if ($story['image']): ?>
              <img src="<?php echo esc_url($story['image']); ?>" 
                   alt="<?php echo esc_attr($story['title']); ?>" 
                   width="512" height="512" loading="lazy" />
              <?php endif; ?>
            </div>
            <div class="content-custome">
              <small class="mb-2"><?php echo esc_html($story['category'] ?: 'FEATURED STORY'); ?></small>
              <h3 class="mb-3"><?php echo esc_html($story['title']); ?></h3>
              <small><?php echo esc_html($story['date']); ?></small>
            </div>
          </a>
        </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>
  </div>
</section>

<script>
function initCardReveal() {
  function addRevealEffect(elements) {
    const observer = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) entry.target.classList.add('reveal-custome');
      });
    }, { threshold: 0.1 });

    elements.forEach((element) => observer.observe(element));
  }

  const elementsToReveal = document.querySelectorAll('.card-custome:not(.hero-custome)');
  addRevealEffect(elementsToReveal);
}

// Call this function when the page loads
document.addEventListener('DOMContentLoaded', initCardReveal);
</script>