<?php
// components/home/globe-world-section.php
?>
<style>
    .globe-world {
      background-color: #212121;
      border-bottom-right-radius: 15vw;
      border-top-right-radius: 15vw;
      position: relative;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .globe-world:before {
      content: "";
      background-color: #212121;
      position: absolute;
      top: 100%;
      left: 0;
      width: 15vw;
      height: 15vw;
    }
    
    .globe-world:after {
      content: "";
      background-color: #fff;
      position: absolute;
      top: 100%;
      left: 0;
      width: 15vw;
      height: 15vw;
      border-top-left-radius: 15vw;
    }

    .wrapper-new {
      --total: 40;
      width: 40vw;
      aspect-ratio: 1;
      perspective: 80rem;
      transform-style: preserve-3d;
      position:relative;
    }

    .wrapper-new::after {
      content: "escope";
      position: absolute;
      inset: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 6vw;
      font-weight: 900;
      color: rgba(255, 255, 255, 0.342);
      letter-spacing: 0.5rem;
      z-index: -1;
    }

    .globe {
      position: relative;
      animation: spin 10s infinite linear;
      transform-style: preserve-3d;
      width: 100%;
      height: 100%;
    }

    .dot {
      --angle: calc(var(--i) * 360deg / var(--total));
      position: absolute;
      left: 0;
      top: 0;
      width: 40vw;
      aspect-ratio: 1;
      border: 3px dotted #e50914;
      border-radius: 50%;
      transform: rotateY(var(--angle)) rotateX(var(--angle));
    }

    @keyframes spin {
      to {
        transform: rotateY(360deg);
      }
    }

    /* Responsive styles */
    @media screen and (max-width: 768px) {
      .wrapper-new {
        width: 60vw;
      }
      
      .dot {
        width: 60vw;
      }
    }

    @media screen and (max-width: 576px) {
      .wrapper-new {
        width: 80vw;
      }
      
      .dot {
        width: 80vw;
      }
      
      .wrapper-new::after {
        font-size: 8vw;
      }
    }
</style>

 <!-- Globe World Section -->
  <section class="globe-world py-5">
    <div class="container d-flex justify-content-center align-items-center">
      <div class="wrapper-new">
        <div class="globe">
          <!-- Generate 40 dots -->
          <div class="dot" style="--i: 0"></div>
          <div class="dot" style="--i: 1"></div>
          <div class="dot" style="--i: 2"></div>
          <div class="dot" style="--i: 3"></div>
          <div class="dot" style="--i: 4"></div>
          <div class="dot" style="--i: 5"></div>
          <div class="dot" style="--i: 6"></div>
          <div class="dot" style="--i: 7"></div>
          <div class="dot" style="--i: 8"></div>
          <div class="dot" style="--i: 9"></div>
          <div class="dot" style="--i: 10"></div>
          <div class="dot" style="--i: 11"></div>
          <div class="dot" style="--i: 12"></div>
          <div class="dot" style="--i: 13"></div>
          <div class="dot" style="--i: 14"></div>
          <div class="dot" style="--i: 15"></div>
          <div class="dot" style="--i: 16"></div>
          <div class="dot" style="--i: 17"></div>
          <div class="dot" style="--i: 18"></div>
          <div class="dot" style="--i: 19"></div>
          <div class="dot" style="--i: 20"></div>
          <div class="dot" style="--i: 21"></div>
          <div class="dot" style="--i: 22"></div>
          <div class="dot" style="--i: 23"></div>
          <div class="dot" style="--i: 24"></div>
          <div class="dot" style="--i: 25"></div>
          <div class="dot" style="--i: 26"></div>
          <div class="dot" style="--i: 27"></div>
          <div class="dot" style="--i: 28"></div>
          <div class="dot" style="--i: 29"></div>
          <div class="dot" style="--i: 30"></div>
          <div class="dot" style="--i: 31"></div>
          <div class="dot" style="--i: 32"></div>
          <div class="dot" style="--i: 33"></div>
          <div class="dot" style="--i: 34"></div>
          <div class="dot" style="--i: 35"></div>
          <div class="dot" style="--i: 36"></div>
          <div class="dot" style="--i: 37"></div>
          <div class="dot" style="--i: 38"></div>
          <div class="dot" style="--i: 39"></div>
        </div>
      </div>
    </div>
  </section>