<?php
// components/home/services-carousel-section.php
?>

<style>
/* Your existing CSS styles remain exactly the same */
.content-section {
  padding: 100px 20px;
  background: white;
  position: relative;
  z-index: 50;
  border-top-left-radius: 15vw; 
}

.carousel-container {
  width: 100%;
  height: 300px;
  position: relative;
  perspective: 1320px;
  margin: 0 auto;
}

.carousel-track {
  width: 100%;
  height: 100%;
  display: flex;
  justify-content: center;
  align-items: center;
  position: relative;
  transform-style: preserve-3d;
  transition: transform 0.8s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

.card {
  position: absolute;
  width: 280px;
  height: 380px;
  background: white;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
  transition: all 0.8s cubic-bezier(0.25, 0.46, 0.45, 0.94);
  cursor: pointer;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 30px;
  text-align: center;
}

.card-icon {
  font-size: 3.5rem;
  color: #000000;
  margin-bottom: 20px;
  transition: all 0.3s ease;
}

.card h3 {
  font-size: 1.8rem;
  font-weight: 700;
  margin-bottom: 15px;
  color: #333;
}

.card p {
  font-size: 1rem;
  line-height: 1.6;
  color: #666;
}

.card.center {
  z-index: 10;
  transform: scale(1.1) translateZ(0);
  background: linear-gradient(135deg, #fff 0%, #f9f9f9 100%);
  box-shadow: 0 25px 50px rgba(229, 9, 20, 0.2);
}

.card.center .card-icon {
  transform: scale(1.2);
  color: #c40811;
}

.card.left-2 {
  z-index: 1;
  transform: translateX(-400px) scale(0.8) translateZ(-300px);
  opacity: 0.7;
  filter: grayscale(30%);
}

.card.left-1 {
  z-index: 5;
  transform: translateX(-200px) scale(0.9) translateZ(-100px);
  opacity: 0.9;
  filter: grayscale(20%);
}

.card.right-1 {
  z-index: 5;
  transform: translateX(200px) scale(0.9) translateZ(-100px);
  opacity: 0.9;
  filter: grayscale(20%);
}

.card.right-2 {
  z-index: 1;
  transform: translateX(400px) scale(0.8) translateZ(-300px);
  opacity: 0.7;
  filter: grayscale(30%);
}

.card.hidden {
  opacity: 0;
  pointer-events: none;
}

/* REMOVED: member-info styles */

.nav-arrow {
  position: absolute;
  top: 50%;
  transform: translateY(-50%);
  background: rgba(229, 9, 20, 0.6);
  color: white;
  width: 40px;
  height: 40px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  z-index: 20;
  transition: all 0.3s ease;
  font-size: 1.5rem;
  border: none;
  outline: none;
  padding-bottom: 4px;
}

.nav-arrow:hover {
  background: rgba(229, 9, 20, 0.9);
  transform: translateY(-50%) scale(1.1);
}

.nav-arrow.left {
  left: 20px;
  padding-right: 3px;
}

.nav-arrow.right {
  right: 20px;
  padding-left: 3px;
}

/* Responsive styles */
@media (max-width: 768px) {
  .card {
    width: 200px;
    height: 280px;
    padding: 20px;
  }
  
  .card-icon {
    font-size: 2.5rem;
    margin-bottom: 15px;
  }
  
  .card h3 {
    font-size: 1.4rem;
    margin-bottom: 10px;
  }
  
  .card p {
    font-size: 0.9rem;
  }

  .card.left-2 {
    transform: translateX(-250px) scale(0.8) translateZ(-300px);
  }

  .card.left-1 {
    transform: translateX(-120px) scale(0.9) translateZ(-100px);
  }

  .card.right-1 {
    transform: translateX(120px) scale(0.9) translateZ(-100px);
  }

  .card.right-2 {
    transform: translateX(250px) scale(0.8) translateZ(-300px);
  }

  /* REMOVED: responsive member-info styles */
}

@media (max-width: 576px) {
  .carousel-container {
    height: 215px;
  }
  
  .card {
    width: 180px;
    height: 250px;
    padding: 15px;
  }
  
  .card-icon {
    font-size: 2rem;
    margin-bottom: 10px;
  }
  
  .card h3 {
    font-size: 1.2rem;
  }
  
  .card p {
    font-size: 0.8rem;
  }
  
  .nav-arrow {
    width: 30px;
    height: 30px;
    font-size: 1.2rem;
  }
  
  .nav-arrow.left {
    left: 10px;
  }
  
  .nav-arrow.right {
    right: 10px;
  }
}
</style>

<section class="content-section">
  <div class="container">
    <?php
    // Get custom field values
    $section_title = get_field('services_carousel_title') ?: 'TEXT EFFECT';
    $section_overlay = get_field('services_carousel_overlay') ?: 'WOAH';
    $services = get_field('services_carousel_items');
    
    // If no services are set, use default values
    if (empty($services)) {
        $services = array(
            array(
                'icon' => 'fas fa-paint-brush',
                'title' => 'Creative Design',
                'description' => 'We create visually stunning designs that capture your brand\'s essence and engage your audience.'
            ),
            array(
                'icon' => 'fas fa-chart-line',
                'title' => 'Digital Marketing',
                'description' => 'Our data-driven marketing strategies help you reach the right audience and maximize ROI.'
            ),
            array(
                'icon' => 'fas fa-code',
                'title' => 'Web Development',
                'description' => 'We build responsive, high-performance websites and applications with cutting-edge technologies.'
            ),
            array(
                'icon' => 'fas fa-mobile-alt',
                'title' => 'Mobile Apps',
                'description' => 'From iOS to Android, we create intuitive mobile experiences that users love.'
            ),
            array(
                'icon' => 'fas fa-search',
                'title' => 'SEO Optimization',
                'description' => 'Boost your visibility and rankings with our comprehensive SEO strategies.'
            ),
            array(
                'icon' => 'fas fa-bullhorn',
                'title' => 'Social Media',
                'description' => 'Engage your audience and build your brand with our social media expertise.'
            )
        );
    }
    ?>
    
    <h1 class="animated-text-new" data-aos="fade-up" data-aos-duration="800">
        <?php echo esc_html($section_title); ?>
        <span class="text-overlay"><?php echo esc_html($section_overlay); ?></span>
    </h1>

    <div class="carousel-container my-5" data-aos="fade-up" data-aos-duration="800" data-aos-delay="300">
      <button class="nav-arrow left">‹</button>
      <div class="carousel-track">
        <?php foreach ($services as $index => $service): ?>
          <div class="card" data-index="<?php echo $index; ?>">
            <i class="<?php echo esc_attr($service['icon']); ?> card-icon"></i>
            <h3><?php echo esc_html($service['title']); ?></h3>
            <p><?php echo esc_html($service['description']); ?></p>
          </div>
        <?php endforeach; ?>
      </div>
      <button class="nav-arrow right">›</button>
    </div>

    <!-- REMOVED: member-info section -->
  </div>
</section>

<script>
function initCarousel() {
  const cards = document.querySelectorAll(".card");
  const leftArrow = document.querySelector(".nav-arrow.left");
  const rightArrow = document.querySelector(".nav-arrow.right");
  let currentIndex = 0;
  let isAnimating = false;

  function updateCarousel(newIndex) {
    if (isAnimating) return;
    isAnimating = true;

    currentIndex = (newIndex + cards.length) % cards.length;

    cards.forEach((card, i) => {
      const offset = (i - currentIndex + cards.length) % cards.length;

      card.classList.remove(
        "center",
        "left-1",
        "left-2",
        "right-1",
        "right-2",
        "hidden"
      );

      if (offset === 0) {
        card.classList.add("center");
      } else if (offset === 1) {
        card.classList.add("right-1");
      } else if (offset === 2) {
        card.classList.add("right-2");
      } else if (offset === cards.length - 1) {
        card.classList.add("left-1");
      } else if (offset === cards.length - 2) {
        card.classList.add("left-2");
      } else {
        card.classList.add("hidden");
      }
    });

    setTimeout(() => {
      isAnimating = false;
    }, 800);
  }

  leftArrow.addEventListener("click", () => {
    updateCarousel(currentIndex - 1);
  });

  rightArrow.addEventListener("click", () => {
    updateCarousel(currentIndex + 1);
  });

  cards.forEach((card, i) => {
    card.addEventListener("click", () => {
      updateCarousel(i);
    });
  });

  document.addEventListener("keydown", (e) => {
    if (e.key === "ArrowLeft") {
      updateCarousel(currentIndex - 1);
    } else if (e.key === "ArrowRight") {
      updateCarousel(currentIndex + 1);
    }
  });

  let touchStartX = 0;
  let touchEndX = 0;

  document.addEventListener("touchstart", (e) => {
    touchStartX = e.changedTouches[0].screenX;
  });

  document.addEventListener("touchend", (e) => {
    touchEndX = e.changedTouches[0].screenX;
    handleSwipe();
  });

  function handleSwipe() {
    const swipeThreshold = 50;
    const diff = touchStartX - touchEndX;

    if (Math.abs(diff) > swipeThreshold) {
      if (diff > 0) {
        updateCarousel(currentIndex + 1);
      } else {
        updateCarousel(currentIndex - 1);
      }
    }
  }

  // Initialize the carousel
  updateCarousel(0);
}

// Call this function when the page loads
document.addEventListener('DOMContentLoaded', initCarousel);
</script>