<?php
// components/location-slider.php
?>
    
<section class="location-slider-section">
    <style>
        :root {
            --bgClr: rgba(11, 15, 39, 0.83);
            --txtClr: #fff;
            --animSpd: 750ms;
        }

        .cont {
            position: relative;
            height: 100vh;
            overflow: hidden;
            border-bottom-right-radius: 15vw;
           border-top-right-radius: 15vw;
        }

        .slider {
            position: relative;
            height: 100%;
            transform: translate3d(0, 0, 0);
            will-change: transform;
            cursor: all-scroll;
            user-select: none;
        }

        .slider.animation {
            transition: transform var(--animSpd) ease-in-out;
        }

        .slider.animation .slide__darkbg {
            transition: transform var(--animSpd) ease-in-out;
        }

        .slider.animation .slide__text {
            transition: transform var(--animSpd) ease-in-out;
        }

        .slider.animation .slide__letter {
            transition: transform var(--animSpd) ease-in-out;
        }

        .slide {
            position: absolute;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
        }

        .slide--1 {
            left: 0%;
        }

        .slide--2 {
            left: 100%;
        }

        .slide--3 {
            left: 200%;
        }

        .slide--4 {
            left: 300%;
        }

        .slide--5 {
            left: 400%;
        }

        .slide__darkbg {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            transform: translate3d(0, 0, 0);
            will-change: transform;
            z-index: 10;
        }

        .slide--1__darkbg {
            left: 0%;
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--1-min-min.jpg') center center no-repeat;
            background-size: cover;
            background-position: 0px center, 0px center;
            transform: translate3d(0, 0, 0);
            will-change: transform;
        }

        .slide--1__darkbg:after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--bgClr);
        }

        .slide--2__darkbg {
            left: -50%;
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--2-min-min.jpg') center center no-repeat;
            background-size: cover;
            background-position: 0px center, 0px center;
            transform: translate3d(0, 0, 0);
            will-change: transform;
        }

        .slide--2__darkbg:after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--bgClr);
        }

        .slide--3__darkbg {
            left: -100%;
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--3-min-min.jpg') center center no-repeat;
            background-size: cover;
            background-position: 0px center, 0px center;
            transform: translate3d(0, 0, 0);
            will-change: transform;
        }

        .slide--3__darkbg:after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--bgClr);
        }

        .slide--4__darkbg {
            left: -150%;
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--4-min-min.jpg') center center no-repeat;
            background-size: cover;
            background-position: 0px center, 0px center;
            transform: translate3d(0, 0, 0);
            will-change: transform;
        }

        .slide--4__darkbg:after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--bgClr);
        }

        .slide--5__darkbg {
            left: -200%;
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--5-min-min.jpg') center center no-repeat;
            background-size: cover;
            background-position: 0px center, 0px center;
            transform: translate3d(0, 0, 0);
            will-change: transform;
        }

        .slide--5__darkbg:after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--bgClr);
        }

        .slide__text-wrapper {
            position: absolute;
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            height: 100%;
            z-index: 15;
        }

        .slide__letter {
            position: absolute;
            display: flex;
            align-items: center;
            justify-content: center;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            transform: translate3d(0, 0, 0);
            -webkit-text-fill-color: transparent !important;
            -webkit-background-clip: text !important;
            font-size: 50vw;
            font-weight: 800;
            color: #000;
            z-index: 2;
            will-change: transform;
            user-select: none;
        }

        .slide--1__letter {
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--1-min-min.jpg') center center no-repeat;
            background-position: 0px center, 0px center;
            background-size: cover;
        }

        .slide--2__letter {
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--2-min-min.jpg') center center no-repeat;
            background-position: 0px center, 0px center;
            background-size: cover;
        }

        .slide--3__letter {
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--3-min-min.jpg') center center no-repeat;
            background-position: 0px center, 0px center;
            background-size: cover;
        }

        .slide--4__letter {
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--4-min-min.jpg') center center no-repeat;
            background-position: 0px center, 0px center;
            background-size: cover;
        }

        .slide--5__letter {
            background: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/537051/city--5-min-min.jpg') center center no-repeat;
            background-position: 0px center, 0px center;
            background-size: cover;
        }

        .slide__text {
            font-size: 8vw;
            font-weight: 800;
            text-transform: uppercase;
            transform: translate3d(0, 0, 0);
            letter-spacing: 12px;
            color: var(--txtClr);
            will-change: transform;
            user-select: none;
        }

        .slide__text:nth-child(odd) {
            z-index: 2;
        }

        .slide__text:nth-child(even) {
            z-index: 1;
        }

        .nav {
            position: absolute;
            bottom: 25px;
            left: 50%;
            transform: translateX(-50%);
            list-style-type: none;
            z-index: 10;
        }

        .nav__slide {
            position: relative;
            display: inline-block;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            border: 2px solid #fff;
            margin-left: 10px;
            cursor: pointer;
        }

        @media screen and (max-width: 400px) {
            .nav__slide {
                width: 22px;
                height: 22px;
            }
        }

        .nav__slide:hover:after {
            transform: translate(-50%, -50%) scale(1, 1);
            opacity: 1;
        }

        .nav__slide:after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0, 0);
            width: 75%;
            height: 75%;
            border-radius: 50%;
            background-color: #fff;
            opacity: 0;
            transition: 300ms;
        }

        .nav__slide--1 {
            margin-left: 0;
        }

        .nav-active:after {
            transform: translate(-50%, -50%) scale(1, 1);
            opacity: 1;
        }

        .side-nav {
            position: absolute;
            width: 10%;
            height: 100%;
            top: 0;
            z-index: 20;
            cursor: pointer;
            opacity: 0;
            transition: 300ms;
        }

        .side-nav:hover {
            opacity: .1;
        }

        .side-nav--right {
            right: 0;
            background-image: linear-gradient(to right, rgba(255, 255, 255, 0) 0%, rgb(238, 215, 255) 100%);
        }

        .side-nav--left {
            left: 0;
            background-image: linear-gradient(to left, rgba(255, 255, 255, 0) 0%, rgb(238, 215, 255) 100%);
        }
    </style>

    <div class="cont">
        <div class="slider"></div>
        <ul class="nav"></ul>
        <div data-target='right' class="side-nav side-nav--right"></div>
        <div data-target='left' class="side-nav side-nav--left"></div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            const $cont = $('.cont');
            const $slider = $('.slider');
            const $nav = $('.nav');
            const winW = $(window).width();
            const animSpd = 750; // Change also in CSS
            const distOfLetGo = winW * 0.2;
            let curSlide = 1;
            let animation = false;
            let diff = 0;
            
            // Generating slides
            let arrCities = ['Amsterdam', 'Rome', 'New—York', 'Singapore', 'Prague']; // Change number of slides in CSS also
            let numOfCities = arrCities.length;
            let arrCitiesDivided = [];
            
            arrCities.map((city) => {
                let length = city.length;
                let letters = Math.floor(length / 4);
                let exp = new RegExp(".{1," + letters + "}", "g");
                
                arrCitiesDivided.push(city.match(exp));
            });
            
            let generateSlide = function(city) {
                let frag1 = $(document.createDocumentFragment());
                let frag2 = $(document.createDocumentFragment());
                const numSlide = arrCities.indexOf(arrCities[city]) + 1;
                const firstLetter = arrCitiesDivided[city][0].charAt(0);
            
                const $slide =
                            $(`<div data-target="${numSlide}" class="slide slide--${numSlide}">
                                    <div class="slide__darkbg slide--${numSlide}__darkbg"></div>
                                    <div class="slide__text-wrapper slide--${numSlide}__text-wrapper"></div>
                                </div>`);
            
                const letter = 
                            $(`<div class="slide__letter slide--${numSlide}__letter">
                                    ${firstLetter}
                                </div>`);
            
                for (let i = 0, length = arrCitiesDivided[city].length; i < length; i++) {
                    const text = 
                                $(`<div class="slide__text slide__text--${i + 1}">
                                        ${arrCitiesDivided[city][i]}
                                    </div>`);
                    frag1.append(text);
                }
            
                const navSlide = $(`<li data-target="${numSlide}" class="nav__slide nav__slide--${numSlide}"></li>`);
                frag2.append(navSlide);
                $nav.append(frag2);
            
                $slide.find(`.slide--${numSlide}__text-wrapper`).append(letter).append(frag1);
                $slider.append($slide);
            
                if (arrCities[city].length <= 4) {
                    $('.slide--'+ numSlide).find('.slide__text').css("font-size", "12vw");
                }
            };
            
            for (let i = 0, length = numOfCities; i < length; i++) {
                generateSlide(i);
            }
            
            $('.nav__slide--1').addClass('nav-active');
            
            // Navigation
            function bullets(dir) {
                $('.nav__slide--' + curSlide).removeClass('nav-active');
                $('.nav__slide--' + dir).addClass('nav-active');
            }
            
            function timeout() {
                animation = false;
            }
            
            function pagination(direction) {
                animation = true;
                diff = 0;
                $slider.addClass('animation');
                $slider.css({
                    'transform': 'translate3d(-' + ((curSlide - direction) * 100) + '%, 0, 0)'
                });
                
                $slider.find('.slide__darkbg').css({
                        'transform': 'translate3d(' + ((curSlide - direction) * 50) + '%, 0, 0)'
                });
                
                $slider.find('.slide__letter').css({
                        'transform': 'translate3d(0, 0, 0)',
                });
                
                $slider.find('.slide__text').css({
                    'transform': 'translate3d(0, 0, 0)'
                });
            }
            
            function navigateRight() {
                if (animation) return;
                
                if (curSlide >= numOfCities) {
                    curSlide = 1;
                } else {
                    curSlide++;
                }
                
                pagination(1);
                setTimeout(timeout, animSpd);
                bullets(curSlide);
            }
            
            function navigateLeft() {
                if (animation) return;
                
                if (curSlide <= 1) {
                    curSlide = numOfCities;
                } else {
                    curSlide--;
                }
                
                pagination(1);
                setTimeout(timeout, animSpd);
                bullets(curSlide);
            }
            
            function toDefault() {
                pagination(1);
                setTimeout(timeout, animSpd);
            }
            
            // Events
            $(document).on('mousedown touchstart', '.slide', function(e) {
                if (animation) return;
                let target = +$(this).attr('data-target');
                let startX = e.pageX || e.originalEvent.touches[0].pageX;
                $slider.removeClass('animation');
                
                $(document).on('mousemove touchmove', function(e) {
                    let x = e.pageX || e.originalEvent.touches[0].pageX;
                    diff = startX - x;
                    if (target === 1 && diff < 0 || target === numOfCities && diff > 0) return;
                    
                    $slider.css({
                        'transform': 'translate3d(-' + ((curSlide - 1) * 100 + (diff / 30)) + '%, 0, 0)'
                    });
                    
                    $slider.find('.slide__darkbg').css({
                        'transform': 'translate3d(' + ((curSlide - 1) * 50 + (diff / 60)) + '%, 0, 0)'
                    });
                    
                    $slider.find('.slide__letter').css({
                        'transform': 'translate3d(' +  (diff / 60) + 'vw, 0, 0)',
                    });
                    
                    $slider.find('.slide__text').css({
                        'transform': 'translate3d(' + (diff / 15) + 'px, 0, 0)'
                    });
                })	
            })
            
            $(document).on('mouseup touchend', function(e) {
                $(document).off('mousemove touchmove');
                
                if (animation) return;
                
                if (diff >= distOfLetGo) {
                    navigateRight();
                } else if (diff <= -distOfLetGo) {
                    navigateLeft();
                } else {
                    toDefault();
                }
            });
            
            $(document).on('click', '.nav__slide:not(.nav-active)', function() {
                let target = +$(this).attr('data-target');
                bullets(target);
                curSlide = target;
                pagination(1);
            });	
            
            $(document).on('click', '.side-nav', function() {
                let target = $(this).attr('data-target');
                
                if (target === 'right') navigateRight();
                if (target === 'left') navigateLeft();
            });
            
            $(document).on('keydown', function(e) {
                if (e.which === 39) navigateRight();
                if (e.which === 37) navigateLeft();
            });
        });
    </script>
</section>