<?php
// components/technology/productivity-slider.php
?>
<style>
    /* Productivity Slider Specific Styles */
        .productivity-slider {
            --gap: 1.25rem;
            --speed: 0.55s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            --closed: 5rem;
            --open: 30rem;
            --accent: #ff6b35;
        }

        .productivity-slider * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .productivity-slider {
            font-family: Inter, sans-serif;
            background: #ffffffff;
            color: #c5c7ce;
            padding: 20px;
        }

        .productivity-slider .head {
            max-width: 1400px;
            margin: auto;
            padding: 70px 20px 40px;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            gap: 2rem;
        }

        .productivity-slider .head h2 {
            font: 400 1.5rem/1.2 Inter, sans-serif;
            color: #fff;
        }

        @media (min-width: 1024px) {
            .productivity-slider .head h2 {
                font-size: 2.25rem;
            }
        }

        .productivity-slider .slider {
            max-width: 1400px;
            margin: auto;
            overflow: hidden;
        }

        .productivity-slider .track {
            display: flex;
            gap: var(--gap);
            align-items: flex-start;
            justify-content: center;
            scroll-behavior: smooth;
            scroll-snap-type: x mandatory;
            padding-bottom: 40px;
            overflow-x: auto;
        }

        .productivity-slider .track::-webkit-scrollbar {
            display: none;
        }

        .productivity-slider .project-card {
            position: relative;
            flex: 0 0 var(--closed);
            height: 26rem;
            border-radius: 1rem;
            overflow: hidden;
            cursor: pointer;
            transition: flex-basis var(--speed), transform var(--speed);
        }

        .productivity-slider .project-card[active] {
            flex-basis: var(--open);
            transform: translateY(-6px);
            box-shadow: 0 18px 55px rgba(0, 0, 0, 0.45);
        }

        .productivity-slider .project-card__bg {
            position: absolute;
            inset: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            filter: brightness(0.75) saturate(75%);
            transition: filter 0.3s, transform var(--speed);
        }

        .productivity-slider .project-card:hover .project-card__bg {
            filter: brightness(0.9) saturate(100%);
            transform: scale(1.06);
        }

        .productivity-slider .project-card__content {
            position: absolute;
            inset: 0;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 0.7rem;
            padding: 0;
            background: linear-gradient(transparent 40%, rgba(0, 0, 0, 0.85) 100%);
            z-index: 2;
        }

        .productivity-slider .project-card__title {
            color: #fff;
            font-weight: 700;
            font-size: 1.35rem;
            writing-mode: vertical-rl;
            transform: rotate(180deg);
        }

        .productivity-slider .project-card__thumb,
        .productivity-slider .project-card__desc,
        .productivity-slider .project-card__btn {
            display: none;
        }

        .productivity-slider .project-card[active] .project-card__content {
            flex-direction: row;
            align-items: center;
            padding: 1.2rem 2rem;
            gap: 1.1rem;
        }

        .productivity-slider .project-card[active] .project-card__title {
            writing-mode: horizontal-tb;
            transform: none;
            font-size: 2.4rem;
        }

        .productivity-slider .project-card[active] .project-card__thumb,
        .productivity-slider .project-card[active] .project-card__desc,
        .productivity-slider .project-card[active] .project-card__btn {
            display: block;
        }

        .productivity-slider .project-card__thumb {
            width: 133px;
            height: 269px;
            border-radius: 0.45rem;
            object-fit: cover;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.4);
        }

        .productivity-slider .project-card__desc {
            color: #ddd;
            font-size: 1rem;
            line-height: 1.4;
            max-width: 16rem;
        }

        .productivity-slider .project-card__btn {
            padding: 0.55rem 1.3rem;
            border: none;
            border-radius: 9999px;
            background: var(--accent);
            color: #fff;
            font-size: 0.9rem;
            font-weight: 600;
            cursor: pointer;
        }

        .productivity-slider .project-card__btn:hover {
            background: #ff824f;
        }

        @media (max-width: 767px) {
            .productivity-slider {
                --closed: 4rem;
                --open: 22rem;
            }

            .productivity-slider .head {
                padding: 50px 20px 30px;
            }

            .productivity-slider .track {
                flex-direction: column;
                scroll-snap-type: y mandatory;
                align-items: center;
                justify-content: flex-start;
                padding-bottom: 0;
            }

            .productivity-slider .project-card {
                height: 20rem;
            }

            .productivity-slider .project-card__title {
                font-size: 1.1rem;
                writing-mode: horizontal-tb;
                transform: none;
                text-align: center;
                padding-inline: 0.3rem;
            }
        }

        @media (max-width: 767px) {
            .productivity-slider {
                --closed: 100%;
                --open: 100%;
                --gap: 0.8rem;
            }

            .productivity-slider .head {
                padding: 30px 15px 20px;
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }

            .productivity-slider .slider {
                padding: 0 15px;
            }

            .productivity-slider .track {
                flex-direction: column;
                scroll-snap-type: y mandatory;
                gap: 0.8rem;
                padding-bottom: 20px;
            }

            .productivity-slider .project-card {
                height: auto;
                min-height: 80px;
                flex: 0 0 auto;
                width: 100%;
                scroll-snap-align: start;
            }

            .productivity-slider .project-card[active] {
                min-height: 300px;
                transform: none;
                box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
            }

            .productivity-slider .project-card__content {
                flex-direction: row;
                justify-content: flex-start;
                padding: 1rem;
                align-items: center;
                gap: 1rem;
            }

            .productivity-slider .project-card__title {
                writing-mode: horizontal-tb;
                transform: none;
                font-size: 1.2rem;
                margin-right: auto;
            }

            .productivity-slider .project-card__thumb,
            .productivity-slider .project-card__desc,
            .productivity-slider .project-card__btn {
                display: none;
            }

            .productivity-slider .project-card[active] .project-card__content {
                align-items: flex-start;
                padding: 1.5rem;
            }

            .productivity-slider .project-card[active] .project-card__title {
                font-size: 1.8rem;
                margin-bottom: 1rem;
                margin-top: 2rem;
            }

            .productivity-slider .project-card[active] .project-card__thumb {
                width: 200px;
                height: 267px;
                border-radius: 0.35rem;
                margin-bottom: 1rem;
            }

            .productivity-slider .project-card[active] .project-card__desc {
                font-size: 0.95rem;
                max-width: 100%;
                margin-bottom: 1rem;
            }

            .productivity-slider .project-card[active] .project-card__btn {
                align-self: center;
                width: 100%;
                text-align: center;
                padding: 0.7rem;
            }
        }


.animated-text-new {
  font-size: 7vw;
  letter-spacing: -.01em;
  line-height: 100%;
  margin: 0;
  width: 100%;
  color: rgb(161 146 146);
  background: linear-gradient(to right, #e50914, #e50914) no-repeat;
  -webkit-background-clip: text;
  background-clip: text;
  background-size: 0%;
  transition: background-size cubic-bezier(.1,.5,.5,1) 0.5s;
  border-bottom: 1px solid #2F2B28;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  position: relative;
  cursor: pointer;
  padding: 0.5rem 0;
}

.animated-text-new:hover > .text-overlay {
  clip-path: polygon(0 0, 100% 0, 100% 100%, 0% 100%);
}
    </style> 
    
    
     <section class="productivity-slider">
        <div class="head">
            <h1 class="animated-text-new mb-4 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">TEXT EFFECT<span class="text-overlay">WOAH</span></h1>
        </div>
        
        <div class="slider">
            <div class="track" id="ps-track">
        
                <article class="project-card" active>
                    <img class="project-card__bg" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/designers.webp" alt="Designers background">
                    <div class="project-card__content">
                        <img class="project-card__thumb" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/img-designer.webp?w=480" alt="Designer">
                        <div>
                            <h3 class="project-card__title">Designers</h3>
                            <p class="project-card__desc">Tools that work like you do.</p>
                            <button class="project-card__btn">Details</button>
                        </div>
                    </div>
                </article>
        
                <article class="project-card">
                    <img class="project-card__bg" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/marketers.webp" alt="Marketers background">
                    <div class="project-card__content">
                        <img class="project-card__thumb" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/img-marketer.webp?w=480" alt="Marketer">
                        <div>
                            <h3 class="project-card__title">Marketers</h3>
                            <p class="project-card__desc">Create faster, explore new possibilities.</p>
                            <button class="project-card__btn">Details</button>
                        </div>
                    </div>
                </article>
        
                <article class="project-card">
                    <img class="project-card__bg" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/filmmakers.webp" alt="Filmmakers background">
                    <div class="project-card__content">
                        <img class="project-card__thumb" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/img-film.webp?w=480" alt="Filmmaker">
                        <div>
                            <h3 class="project-card__title">VFX filmmakers</h3>
                            <p class="project-card__desc">From concept to cut, faster.</p>
                            <button class="project-card__btn">Details</button>
                        </div>
                    </div>
                </article>
        
                <article class="project-card">
                    <img class="project-card__bg" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/content-creators.webp" alt="Content creators background">
                    <div class="project-card__content">
                        <img class="project-card__thumb" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/img-content.webp?w=480" alt="Content creator">
                        <div>
                            <h3 class="project-card__title">Content creators</h3>
                            <p class="project-card__desc">Make scroll-stopping content, easily.</p>
                            <button class="project-card__btn">Details</button>
                        </div>
                    </div>
                </article>
        
                <article class="project-card">
                    <img class="project-card__bg" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/art-directors.webp" alt="Art directors background">
                    <div class="project-card__content">
                        <img class="project-card__thumb" src="https://cdn-front.freepik.com/home/anon-rvmp/professionals/img-art.webp?w=480" alt="Art director">
                        <div>
                            <h3 class="project-card__title">Art directors</h3>
                            <p class="project-card__desc">Creative control at every stage.</p>
                            <button class="project-card__btn">Details</button>
                        </div>
                    </div>
                </article>
        
            </div>
        </div>
    </section>
<script>
        // Productivity Slider Specific JavaScript
        (() => {
            const track = document.getElementById("ps-track");
            const wrap = track.parentElement;
            const cards = Array.from(track.getElementsByClassName('project-card'));
        
            const isMobile = () => matchMedia("(max-width:767px)").matches;
        
            let current = 0;
        
            function center(i) {
                const card = cards[i];
                const axis = isMobile() ? "top" : "left";
                const size = isMobile() ? "clientHeight" : "clientWidth";
                const start = isMobile() ? card.offsetTop : card.offsetLeft;
                wrap.scrollTo({
                    [axis]: start - (wrap[size] / 2 - card[size] / 2),
                    behavior: "smooth"
                });
            }
        
            function toggleUI(i) {
                cards.forEach((c, k) => c.toggleAttribute("active", k === i));
            }
        
            function activate(i, scroll) {
                if (i === current) return;
                current = i;
                toggleUI(i);
                if (scroll) center(i);
            }
        
            // Only attach keyboard events when slider is in focus
            const sliderSection = document.querySelector('.productivity-slider');
            sliderSection.addEventListener('keydown', (e) => {
                if (["ArrowRight", "ArrowDown"].includes(e.key)) activate(Math.min(current + 1, cards.length - 1), true);
                if (["ArrowLeft", "ArrowUp"].includes(e.key)) activate(Math.max(current - 1, 0), true);
            }, { passive: true });
        
            cards.forEach((card, i) => {
                card.addEventListener(
                    "mouseenter",
                    () => matchMedia("(hover:hover)").matches && activate(i, true)
                );
                card.addEventListener("click", () => activate(i, true));
            });
        
            let sx = 0,
                sy = 0;
            track.addEventListener(
                "touchstart",
                (e) => {
                    sx = e.touches[0].clientX;
                    sy = e.touches[0].clientY;
                },
                { passive: true }
            );
        
            track.addEventListener(
                "touchend",
                (e) => {
                    const dx = e.changedTouches[0].clientX - sx;
                    const dy = e.changedTouches[0].clientY - sy;
                    if (isMobile() ? Math.abs(dy) > 60 : Math.abs(dx) > 60)
                        activate((isMobile() ? dy : dx) > 0 ? Math.max(current - 1, 0) : Math.min(current + 1, cards.length - 1), true);
                },
                { passive: true }
            );
        
            window.addEventListener("resize", () => center(current));
        
            toggleUI(0);
            center(0);
        })();
    </script>