<?php
// components/technology/technology-card.php
?>

<section class="services-section min-h-screen bg-gray-900 text-center py-20 px-8 xl:px-0 flex flex-col justify-center globe-world">
  <div class="head">
            <h1 class="animated-text-new mb-4 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">TEXT EFFECT<span class="text-overlay">WOAH</span></h1>
        </div>
  <div class="services-section-grid text-left grid sm:grid-cols-2 md:grid-cols-2 gap-5 max-w-5xl mx-auto">
    <div class="services-section-card bg-gray-800 p-10 relative">
      <div class="services-section-circle"></div>
      <div class="services-section-content relative lg:pr-52">
        <h2 class="services-section-card-title capitalize text-white mb-4 text-2xl xl:text-3xl">
          uI/uX <br /> creative design
        </h2>
        <p class="services-section-card-text text-gray-400">
          Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames.
        </p>
      </div>
      <div class="services-section-icon"></div>
    </div>
    <div class="services-section-card bg-gray-800 p-10 relative">
      <div class="services-section-circle"></div>
      <div class="services-section-content relative lg:pl-48">
        <h2 class="services-section-card-title capitalize text-white mb-4 text-2xl xl:text-3xl">
          visual <br /> graphic design
        </h2>
        <p class="services-section-card-text text-gray-400">
          Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames.
        </p>
      </div>
      <div class="services-section-icon"></div>
    </div>
    <div class="services-section-card bg-gray-800 p-10 relative">
      <div class="services-section-circle"></div>
      <div class="services-section-content relative lg:pr-44">
        <h2 class="services-section-card-title capitalize text-white mb-4 text-2xl xl:text-3xl">
          strategy & <br />digital marketing
        </h2>
        <p class="services-section-card-text text-gray-400">
          Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames.
        </p>
      </div>
      <div class="services-section-icon"></div>
    </div>
    <div class="services-section-card bg-gray-800 p-10 relative">
      <div class="services-section-circle"></div>
      <div class="services-section-content relative lg:pl-48">
        <h2 class="services-section-card-title capitalize text-white mb-4 text-2xl xl:text-3xl">
          effective<br /> business growth
        </h2>
        <p class="services-section-card-text text-gray-400">
          Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames.
        </p>
      </div>
      <div class="services-section-icon"></div>
    </div>
  </div>
</section>

<style>
@import url("https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;1,400&display=swap");

/* Globe world background styles */
.services-section.globe-world {
  background-color: #212121;
  border-bottom-right-radius: 15vw;
  border-top-right-radius: 15vw;
  position: relative;
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
}

.services-section.globe-world:before {
  content: "";
  background-color: #212121;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
}

.services-section.globe-world:after {
  content: "";
  background-color: #fff;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
  border-top-left-radius: 15vw;
}

/* Scoped styles for the services section only */
.services-section {
  /* Layout styles */
  min-height: 100vh;
  text-align: center;
  padding: 5rem 2rem;
  display: flex;
  flex-direction: column;
  justify-content: center;
}

@media (min-width: 1280px) {
  .services-section {
    padding-left: 0;
    padding-right: 0;
  }
}

.services-section-subtitle {
  color: #9ca3af;
  font-size: 1.125rem;
  max-width: 32rem;
  margin: 0 auto 0.5rem;
  text-transform: capitalize;
  display: flex;
  align-items: center;
}

.services-section-subtitle svg {
  color: #e50914;
  margin-left: 0.75rem;
  width: 1.5rem;
  height: 1.5rem;
}

.services-section-title {
  color: #ffffff;
  font-size: 2.25rem;
  font-weight: 600;
  max-width: 48rem;
  margin: 0 auto 4rem;
  line-height: 1.375;
}

@media (min-width: 768px) {
  .services-section-title {
    font-size: 3rem;
  }
}

@media (min-width: 1280px) {
  .services-section-title {
    font-size: 3.75rem;
  }
}

.services-section-grid {
  text-align: left;
  display: grid;
  grid-template-columns: repeat(1, minmax(0, 1fr));
  gap: 1.25rem;
  max-width: 64rem;
  margin: 0 auto;
}

@media (min-width: 640px) {
  .services-section-grid {
    grid-template-columns: repeat(2, minmax(0, 1fr));
  }
}

.services-section-card {
  position: relative;
  background-color: #fa000034;
  padding: 2.5rem;
  overflow: hidden;
  border-radius: 0.5rem;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.services-section-card:hover {
  transform: translateY(-5px);
  box-shadow: 0.063rem 0.063rem 1.25rem 0.375rem rgb(0 0 0 / 53%);
}

.services-section-card::before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  transition: 0.6s;
  z-index: 0;
  background-color: #e50914;
}

.services-section-card:nth-child(1)::before {
  bottom: 0;
  right: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 100% 100%);
}

.services-section-card:nth-child(2)::before {
  bottom: 0;
  left: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 0% 100%);
}

.services-section-card:nth-child(3)::before {
  top: 0;
  right: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 100% 0%);
}

.services-section-card:nth-child(4)::before {
  top: 0;
  left: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 0% 0%);
}

.services-section-card:hover::before {
  clip-path: circle(110vw at 100% 100%);
}

.services-section-content {
  position: relative;
  z-index: 1;
}

@media (min-width: 1024px) {
  .services-section-card:nth-child(1) .services-section-content {
    padding-right: 13rem;
  }
  
  .services-section-card:nth-child(2) .services-section-content {
    padding-left: 12rem;
  }
  
  .services-section-card:nth-child(3) .services-section-content {
    padding-right: 11rem;
  }
  
  .services-section-card:nth-child(4) .services-section-content {
    padding-left: 12rem;
  }
}

.services-section-card-title {
  font-family: "Playfair Display", serif;
  font-optical-sizing: auto;
  font-weight: 400;
  font-style: normal;
  color: #ffffff;
  text-transform: capitalize;
  margin-bottom: 1rem;
  font-size: 1.5rem;
}

@media (min-width: 1280px) {
  .services-section-card-title {
    font-size: 1.875rem;
  }
}

.services-section-card-text {
  color: #9ca3af;
  transition: 0.8s;
  position: relative;
  z-index: 1;
}

.services-section-card:hover .services-section-card-text {
  color: #fff;
}

.services-section-circle {
  display: none;
}

@media (min-width: 62.5rem) {
  .services-section-circle {
    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 0;
    display: block;
  }
}

.services-section-card:nth-child(1) .services-section-circle {
  background: url("https://images.unsplash.com/photo-1587440871875-191322ee64b0?q=80&w=2071&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D")
    no-repeat 50% 50% / cover;
  bottom: 0;
  right: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 100% 100%);
}

.services-section-card:nth-child(2) .services-section-circle {
  background: url("https://images.unsplash.com/photo-1499951360447-b19be8fe80f5?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D")
    no-repeat 50% 50% / cover;
  bottom: 0;
  left: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 0% 100%);
}

.services-section-card:nth-child(3) .services-section-circle {
  background: url("https://images.unsplash.com/photo-1557804506-669a67965ba0?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D")
    no-repeat 50% 50% / cover;
  top: 0;
  right: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 100% 0%);
}

.services-section-card:nth-child(4) .services-section-circle {
  background: url("https://images.unsplash.com/photo-1600880292203-757bb62b4baf?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D")
    no-repeat 50% 50% / cover;
  top: 0;
  left: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 0% 0%);
}

.services-section-icon {
  position: absolute;
  bottom: 2rem;
  right: 2rem;
  font-size: 2rem;
  color: #e50914;
  z-index: 1;
  transition: transform 0.3s ease;
}

.services-section-card:hover .services-section-icon {
  transform: scale(1.1);
}

.services-section-card:nth-child(1) .services-section-icon::before {
  content: "\f53f";
  font-family: "Font Awesome 6 Free";
  font-weight: 900;
}

.services-section-card:nth-child(2) .services-section-icon::before {
  content: "\f03e";
  font-family: "Font Awesome 6 Free";
  font-weight: 900;
}

.services-section-card:nth-child(3) .services-section-icon::before {
  content: "\f201";
  font-family: "Font Awesome 6 Free";
  font-weight: 900;
}

.services-section-card:nth-child(4) .services-section-icon::before {
  content: "\f062";
  font-family: "Font Awesome 6 Free";
  font-weight: 900;
}

/* Responsive adjustments */
@media (max-width: 768px) {
  .services-section {
    padding: 3rem 1rem;
  }
  
  .services-section-card {
    padding: 1.5rem;
  }
}
</style>