<?php
/**
 * Template Name: contact
 * Created on : Aug 18, 2025
 * Author: Minidu Sathsara
 */
get_header(); ?>

<!-- Parallax Hero Section with Contact Form -->
<section class="parallax-hero">
    <div class="parallax-container">
        <!-- Background Layers -->
        <div class="parallax-layer" data-speed="0.5">
            <img src="https://cdn.prod.website-files.com/671752cd4027f01b1b8f1c7f/6717795be09b462b2e8ebf71_osmo-parallax-layer-3.webp" alt="Background Layer">
        </div>
        <div class="parallax-layer" data-speed="0.3">
            <img src="https://cdn.prod.website-files.com/671752cd4027f01b1b8f1c7f/6717795b4d5ac529e7d3a562_osmo-parallax-layer-2.webp" alt="Middle Layer">
        </div>
        <div class="parallax-layer" data-speed="0.1">
            <img src="https://cdn.prod.website-files.com/671752cd4027f01b1b8f1c7f/6717795bb5aceca85011ad83_osmo-parallax-layer-1.webp" alt="Foreground Layer">
        </div>
        
        <!-- Title Layer -->
        <div class="parallax-layer" data-speed="0.2">
            <div class="parallax-content">
                <h1 class="parallax-title">Contact Us</h1>
            </div>
        </div>
        
        <!-- Contact Form Layer -->
        <div class="parallax-layer contact-layer" data-speed="0.15">
            <div class="contact-parallax-container">
                <div class="contact-form-wrapper">
                    <h2 class="contact-parallax-title">Get In Touch</h2>
                    <p class="contact-parallax-subtitle">We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
                    
                    <div class="contact-form-parallax">
                        <form class="custom-contact-form" id="customContactForm">
                            <div class="form-row">
                                <div class="form-group">
                                    <input type="text" id="firstName" name="firstName" class="form-control" placeholder="First Name" required>
                                    <label for="firstName">First Name</label>
                                    <span class="focus-border"></span>
                                </div>
                                <div class="form-group">
                                    <input type="text" id="lastName" name="lastName" class="form-control" placeholder="Last Name" required>
                                    <label for="lastName">Last Name</label>
                                    <span class="focus-border"></span>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <input type="email" id="email" name="email" class="form-control" placeholder="Email Address" required>
                                <label for="email">Email Address</label>
                                <span class="focus-border"></span>
                            </div>
                            
                            <div class="form-group">
                                <input type="tel" id="phone" name="phone" class="form-control" placeholder="Phone Number (Optional)">
                                <label for="phone">Phone Number (Optional)</label>
                                <span class="focus-border"></span>
                            </div>
                            
                            <div class="form-group">
                                <select id="subject" name="subject" class="form-control" required>
                                    <option value="">Select a subject</option>
                                    <option value="general">General Inquiry</option>
                                    <option value="support">Technical Support</option>
                                    <option value="sales">Sales Question</option>
                                    <option value="partnership">Partnership</option>
                                    <option value="other">Other</option>
                                </select>
                                <label for="subject">Subject</label>
                                <span class="focus-border"></span>
                            </div>
                            
                            <div class="form-group">
                                <textarea id="message" name="message" class="form-control" rows="5" placeholder="Your Message" required></textarea>
                                <label for="message">Your Message</label>
                                <span class="focus-border"></span>
                            </div>
                            
                            <div class="form-submit">
                                <button type="submit" class="submit-btn">
                                    <span class="btn-text">Send Message</span>
                                    <span class="btn-loading">
                                        <i class="fas fa-spinner fa-spin"></i>
                                    </span>
                                </button>
                            </div>
                            
                            <div class="form-message" id="formMessage"></div>
                        </form>
                    </div>
                    
                 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Parallax Hero Section */
.parallax-hero {
    height: 300vh; /* Extended height for parallax scrolling */
    position: relative;
    overflow: hidden;
    background: #212121;
}

.parallax-container {
    position: relative;
    height: 100%;
    width: 100%;
}

.parallax-layer {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 120%;
    overflow: hidden;
}

.parallax-layer img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
}

.parallax-content {
    position: absolute;
    top: 10%;
    left: 50%;
    transform: translateX(-50%);
    z-index: 10;
    text-align: center;
    width: 100%;
}

.parallax-title {
    font-size: clamp(3rem, 10vw, 8rem);
    font-weight: 900;
    color: #fff;
    mix-blend-mode: difference;
    text-transform: uppercase;
    letter-spacing: -2px;
    margin: 0;
    font-family: 'Montserrat', sans-serif;
}

/* Contact Form Layer */
.contact-layer {
    z-index: 15;
    pointer-events: auto;
}

.contact-parallax-container {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 90%;
    max-width: 800px;
    z-index: 20;
}

.contact-form-wrapper {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    padding: 50px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.contact-parallax-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: #212121;
    margin-bottom: 15px;
    text-align: center;
    font-family: 'Montserrat', sans-serif;
}

.contact-parallax-subtitle {
    font-size: 1.1rem;
    color: #666;
    text-align: center;
    margin-bottom: 30px;
    line-height: 1.6;
}

/* Custom Contact Form Styles */
.custom-contact-form {
    margin-bottom: 30px;
}

.form-row {
    display: flex;
    gap: 20px;
    margin-bottom: 20px;
}

.form-group {
    position: relative;
    margin-bottom: 25px;
    flex: 1;
}

.form-control {
    width: 100%;
    padding: 15px;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-family: 'Montserrat', sans-serif;
    font-size: 1rem;
    background: rgba(255, 255, 255, 0.9);
    transition: all 0.3s ease;
    outline: none;
}

.form-control:focus {
    border-color: #e50914;
    box-shadow: 0 0 0 3px rgba(229, 9, 20, 0.1);
}

/* Floating Labels */
.form-group {
    position: relative;
}

.form-group label {
    position: absolute;
    top: 15px;
    left: 15px;
    font-size: 1rem;
    color: #999;
    pointer-events: none;
    transition: all 0.3s ease;
    background: rgba(255, 255, 255, 0.9);
    padding: 0 5px;
    font-family: 'Montserrat', sans-serif;
}

.form-control:focus + label,
.form-control:not(:placeholder-shown) + label,
.form-control.has-value + label {
    top: -8px;
    left: 10px;
    font-size: 0.8rem;
    color: #e50914;
    font-weight: 600;
}

/* Focus Border Animation */
.focus-border {
    position: absolute;
    bottom: 0;
    left: 50%;
    width: 0;
    height: 2px;
    background: #e50914;
    transition: all 0.3s ease;
    transform: translateX(-50%);
}

.form-control:focus ~ .focus-border {
    width: 100%;
}

/* Select Styling */
.form-group select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%23999' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 15px center;
    background-size: 16px;
    padding-right: 45px;
}

/* Textarea Styling */
textarea.form-control {
    resize: vertical;
    min-height: 120px;
}

/* Submit Button */
.form-submit {
    text-align: center;
    margin-top: 30px;
}

.submit-btn {
    background: #e50914;
    color: white;
    border: none;
    padding: 15px 40px;
    border-radius: 8px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-family: 'Montserrat', sans-serif;
    font-size: 1.1rem;
    position: relative;
    overflow: hidden;
    min-width: 160px;
}

.submit-btn:hover {
    background: #c40811;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(200, 8, 17, 0.4);
}

.submit-btn:active {
    transform: translateY(0);
}

.btn-loading {
    display: none;
}

.submit-btn.loading .btn-text {
    display: none;
}

.submit-btn.loading .btn-loading {
    display: inline-block;
}

/* Form Messages */
.form-message {
    margin-top: 20px;
    padding: 15px;
    border-radius: 8px;
    text-align: center;
    font-weight: 500;
    display: none;
}

.form-message.success {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
    display: block;
}

.form-message.error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
    display: block;
}

/* Contact Info in Parallax */
.contact-info-parallax {
    margin-top: 30px;
}

.contact-info-row {
    display: flex;
    justify-content: space-between;
    gap: 20px;
}

.contact-info-item-parallax {
    flex: 1;
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 20px;
    background: rgba(255, 255, 255, 0.5);
    border-radius: 12px;
    transition: all 0.3s ease;
}

.contact-info-item-parallax:hover {
    background: rgba(255, 255, 255, 0.8);
    transform: translateY(-5px);
}

.contact-info-item-parallax i {
    font-size: 1.8rem;
    color: #e50914;
    min-width: 30px;
}

.info-text h4 {
    font-size: 1.1rem;
    font-weight: 700;
    margin-bottom: 5px;
    color: #333;
}

.info-text p {
    font-size: 0.9rem;
    color: #666;
    margin: 0;
    line-height: 1.4;
}

/* Media Queries */
@media screen and (max-width: 992px) {
    .parallax-hero {
        height: 200vh;
    }
    
    .contact-form-wrapper {
        padding: 40px 30px;
    }
    
    .contact-parallax-title {
        font-size: 2rem;
    }
    
    .contact-info-row {
        flex-direction: column;
    }
    
    .contact-info-item-parallax {
        justify-content: center;
        text-align: center;
    }
    
    .form-row {
        flex-direction: column;
        gap: 0;
    }
}

@media screen and (max-width: 768px) {
    .parallax-hero {
        height: 180vh;
    }
    
    .parallax-title {
        font-size: clamp(2.5rem, 8vw, 5rem);
    }
    
    .contact-form-wrapper {
        padding: 30px 20px;
    }
    
    .contact-parallax-title {
        font-size: 1.8rem;
    }
    
    .contact-parallax-subtitle {
        font-size: 1rem;
    }
}

@media screen and (max-width: 576px) {
    .parallax-hero {
        height: 150vh;
    }
    
    .contact-form-wrapper {
        padding: 25px 15px;
    }
    
    .contact-parallax-title {
        font-size: 1.5rem;
    }
    
    .form-control {
        padding: 12px;
        font-size: 16px; /* Prevents zoom on iOS */
    }
    
    .submit-btn {
        padding: 12px 25px;
        font-size: 1rem;
    }
    
    .contact-info-item-parallax {
        padding: 15px;
    }
    
    .contact-info-item-parallax i {
        font-size: 1.5rem;
    }
    
    /* Mobile-specific form fixes */
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-group label {
        font-size: 14px;
    }
    
    .form-control:focus + label,
    .form-control:not(:placeholder-shown) + label,
    .form-control.has-value + label {
        font-size: 12px;
    }
}
</style>

<!-- Enhanced Parallax Script with Form Handling -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const parallaxLayers = document.querySelectorAll('.parallax-layer');
    const parallaxHero = document.querySelector('.parallax-hero');
    const contactLayer = document.querySelector('.contact-layer');
    const contactForm = document.getElementById('customContactForm');
    const formMessage = document.getElementById('formMessage');
    
    // Check if device is mobile
    const isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    
    // Parallax functionality
    if (parallaxLayers.length > 0 && parallaxHero) {
        // Set initial positions
        parallaxLayers.forEach(layer => {
            const speed = layer.dataset.speed || 0.5;
            layer.style.transform = `translateY(0px)`;
        });
        
        // Enhanced parallax on scroll
        window.addEventListener('scroll', function() {
            const scrolled = window.pageYOffset;
            const parallaxHeight = parallaxHero.offsetHeight;
            const windowHeight = window.innerHeight;
            
            // Apply parallax when within the hero section
            if (scrolled < parallaxHeight) {
                parallaxLayers.forEach(layer => {
                    const speed = layer.dataset.speed || 0.5;
                    const yPos = -(scrolled * speed);
                    layer.style.transform = `translateY(${yPos}px)`;
                });
                
                // Fade in contact form as user scrolls
                if (contactLayer) {
                    const contactOpacity = Math.min(1, (scrolled - windowHeight * 0.1) / (windowHeight * 0.3));
                    contactLayer.style.opacity = contactOpacity;
                    contactLayer.style.pointerEvents = contactOpacity > 0.3 ? 'auto' : 'none';
                }
            }
        });
        
        // Subtle parallax on mouse move (only for desktop)
        if (!isMobile) {
            parallaxHero.addEventListener('mousemove', function(e) {
                const mouseX = (e.clientX / window.innerWidth - 0.5) * 20;
                const mouseY = (e.clientY / window.innerHeight - 0.5) * 20;
                
                parallaxLayers.forEach((layer, index) => {
                    const speed = (index + 1) * 0.5;
                    const x = mouseX * speed;
                    const y = mouseY * speed;
                    
                    const currentTransform = layer.style.transform;
                    const translateY = currentTransform.match(/translateY\(([^)]+)\)/);
                    const currentY = translateY ? translateY[1] : '0px';
                    
                    layer.style.transform = `translateX(${x}px) translateY(${currentY})`;
                });
            });
            
            // Reset on mouse leave
            parallaxHero.addEventListener('mouseleave', function() {
                const scrolled = window.pageYOffset;
                
                parallaxLayers.forEach(layer => {
                    const speed = layer.dataset.speed || 0.5;
                    const yPos = -(scrolled * speed);
                    layer.style.transform = `translateY(${yPos}px)`;
                });
            });
        }
        
        // Initialize contact form opacity
        if (contactLayer) {
            contactLayer.style.opacity = '0.3';
            contactLayer.style.transition = 'opacity 0.3s ease';
            contactLayer.style.pointerEvents = 'auto';
        }
    }
    
    // Contact Form Handling
    if (contactForm) {
        // Initialize floating labels
        const formInputs = contactForm.querySelectorAll('.form-control');
        formInputs.forEach(input => {
            // Check if input has value on load
            if (input.value) {
                input.classList.add('has-value');
            }
            
            input.addEventListener('focus', function() {
                this.parentElement.classList.add('focused');
            });
            
            input.addEventListener('blur', function() {
                if (!this.value) {
                    this.parentElement.classList.remove('focused');
                }
                this.classList.toggle('has-value', this.value !== '');
            });
            
            // Handle input changes
            input.addEventListener('input', function() {
                this.classList.toggle('has-value', this.value !== '');
            });
        });
        
        // Form submission
        contactForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = this.querySelector('.submit-btn');
            const formData = new FormData(this);
            
            // Show loading state
            submitBtn.classList.add('loading');
            formMessage.style.display = 'none';
            
            // Simulate form submission (replace with actual AJAX call)
            setTimeout(() => {
                // Reset loading state
                submitBtn.classList.remove('loading');
                
                // Show success message
                formMessage.textContent = 'Thank you! Your message has been sent successfully. We\'ll get back to you soon.';
                formMessage.className = 'form-message success';
                formMessage.style.display = 'block';
                
                // Reset form
                contactForm.reset();
                formInputs.forEach(input => {
                    input.classList.remove('has-value');
                    input.parentElement.classList.remove('focused');
                });
                
                // Hide message after 5 seconds
                setTimeout(() => {
                    formMessage.style.display = 'none';
                }, 5000);
                
            }, 2000);
        });
    }
    
    // Initialize Map (if needed)
    function initMap() {
        if (document.getElementById('map') && typeof google !== 'undefined') {
            try {
                const mapLocation = { lat: 40.7128, lng: -74.0060 };
                const map = new google.maps.Map(document.getElementById('map'), {
                    zoom: 14,
                    center: mapLocation,
                    styles: [
                        {
                            "featureType": "all",
                            "elementType": "geometry",
                            "stylers": [{"color": "#212121"}]
                        },
                        {
                            "featureType": "all",
                            "elementType": "labels.text.fill",
                            "stylers": [{"color": "#757575"}]
                        },
                        {
                            "featureType": "all",
                            "elementType": "labels.text.stroke",
                            "stylers": [{"color": "#212121"}]
                        },
                        {
                            "featureType": "water",
                            "elementType": "geometry",
                            "stylers": [{"color": "#000000"}]
                        }
                    ]
                });
                
                const marker = new google.maps.Marker({
                    position: mapLocation,
                    map: map,
                    title: "Escope Office"
                });
            } catch (error) {
                console.error('Map initialization error:', error);
            }
        }
    }
    
    // Initialize map if Google Maps is available
    if (typeof google !== 'undefined' && typeof google.maps !== 'undefined') {
        initMap();
    }
});
</script>

