<?php
// components/brand.php

// Check if ACF function exists and if we have brand carousel items
if (function_exists('get_field') && have_rows('brand_carousel_items')): 
?>

<style>
.brand-carousel {
  position: relative;
  width: 100%;
  overflow: hidden;
  padding: 20px 0;
  z-index: 100;
  --duration: 20s;
}

.brand-carousel__container {
  position: relative;
  width: 100%;
  overflow: hidden;
}

.brand-carousel__track {
  display: flex;
  gap: 40px;
  padding: 0 40px;
  will-change: transform;
  animation: scroll-x var(--duration) linear infinite;
  transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

@keyframes scroll-x {
  0% {
    transform: translateX(0);
  }
  100% {
    transform: translateX(-50%);
  }
}

.brand-carousel__slide {
  flex-shrink: 0;
  width: 200px;
  height: 120px;
  background: white;
  border-radius: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
  padding: 20px;
  border: 1px solid #00000026;
}

.brand-carousel__slide:hover {
  transform: scale(1.05) translateY(-5px);
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.18);
}

.brand-carousel__slide-img {
  max-width: 100%;
  max-height: 100%;
  object-fit: contain;
}

/* Pause animation on hover */
.brand-carousel:hover .brand-carousel__track {
  animation-play-state: paused;
}
</style>

<!-- brand carousel starts here -->
<section class="brand-carousel">
  <div class="brand-carousel__container">
    <div class="brand-carousel__track" id="brandCarouselTrack">
      <?php 
      // First loop - display all items
      while (have_rows('brand_carousel_items')): the_row();
        $brand_logo = get_sub_field('brand_logo');
        $brand_name = get_sub_field('brand_name');
        
        if ($brand_logo):
      ?>
        <div class="brand-carousel__slide">
          <img
            class="brand-carousel__slide-img"
            src="<?php echo esc_url($brand_logo['url']); ?>"
            alt="<?php echo esc_attr($brand_name ?: $brand_logo['alt']); ?>"
            loading="lazy"
          />
        </div>
      <?php 
        endif;
      endwhile; 
      
      // Second loop - duplicate items for seamless loop
      reset_rows();
      while (have_rows('brand_carousel_items')): the_row();
        $brand_logo = get_sub_field('brand_logo');
        $brand_name = get_sub_field('brand_name');
        
        if ($brand_logo):
      ?>
        <div class="brand-carousel__slide">
          <img
            class="brand-carousel__slide-img"
            src="<?php echo esc_url($brand_logo['url']); ?>"
            alt="<?php echo esc_attr($brand_name ?: $brand_logo['alt']); ?>"
            loading="lazy"
          />
        </div>
      <?php 
        endif;
      endwhile; 
      ?>
    </div>
  </div>
</section>
<!-- brand carousel ends here -->

<?php endif; ?>