
<?php
// components/contact-hero.php
?>



<section class="hero-section">
      <div class="video-background">
        <video autoplay muted loop playsinline>
          <source src="assets/videos/hero-video.mp4" type="video/mp4" />
        </video>
      </div>
      <div class="video-overlay"></div>

      <div class="social-sidebar">
        <a href="#" class="social-icon"
          ><img src="assets/images/insta.png"
        /></a>
        <a href="#" class="social-icon"><img src="assets/images/you.png" /></a>
        <a href="#" class="social-icon"><img src="assets/images/fb.png" /></a>
        <a href="#" class="social-icon"><img src="assets/images/x.png" /></a>
      </div>

      <div class="hero-content">
        <div class="text-content">
          <div class="subtitle">
            South Carolina Personal Injury & Criminal Defense Lawyer
          </div>

          <h1 class="main-heading">
            YOU HAVE RIGHTS<br />
            WE <span class="highlight">PROTECT</span> THEM
          </h1>

          <p class="description">
            We founded our law firm in 1997, based on the premise that we would
            fight to uphold any and all legal rights that our clients are
            afforded under U.S. law. We focus our practice in two areas only
            criminal defence and personal injury.
          </p>

          <a href="tel:8648100384" class="cta-button">
            <span class="cta-label">Get Free Consultation</span>
            <span class="cta-phone">(864) 810-0384</span>
          </a>
        </div>
      </div>

      <div class="image-content">
        <!-- Replace with your flag PNG image -->
        <img
          src="assets/images/flag.png"
          alt="American Flag"
          class="decorative-flag"
        />

        <!-- Replace with your lawyer PNG image -->
        <img src="assets/images/man-1.png" alt="Lawyer" class="lawyer-image" />
      </div>
    </section>
    <!-- hero section ends here -->


    <style>
        .hero-section {
  position: relative;
  width: 100%;
  min-height: 90vh;
  display: flex;
  align-items: center;
  overflow: hidden;
  background: #f5f5f5;
}

.hero-section .video-background {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  overflow: hidden;
  z-index: 0;
}

.hero-section .video-background video {
  position: absolute;
  top: 50%;
  left: 50%;
  min-width: 100%;
  min-height: 100%;
  width: auto;
  height: auto;
  transform: translate(-50%, -50%);
  object-fit: cover;
}

.hero-section .video-overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(255, 255, 255, 0.85);
  z-index: 1;
}

.hero-section .social-sidebar {
  position: relative;
  left: 40px;
  top: 50%;
  transform: translateY(-50%);
  z-index: 100;
  display: flex;
  flex-direction: column;
  gap: 20px;
  align-items: center;
}

.hero-section .social-sidebar::before {
  content: "SOCIAL";
  writing-mode: vertical-rl;
  transform: rotate(180deg);
  font-size: 11px;
  letter-spacing: 3px;
  color: #333;
  font-weight: 600;
  margin-bottom: 20px;
}

.hero-section .social-icon {
  width: 40px;
  height: 40px;
  background: transparent;
  border: 2px solid #333;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  color: #333;
  text-decoration: none;
  transition: all 0.3s ease;
  font-size: 16px;
}

.hero-section .social-icon:hover {
  background: #c41e3a;
  border-color: #c41e3a;
  color: white;
  transform: scale(1.1);
}

.hero-section .hero-content {
  position: relative;
  z-index: 10;
  width: 100%;
  max-width: 1100px;
  margin: 0 auto;
  display: grid;
  grid-template-columns: 2fr 1fr;
  align-items: center;
}

.hero-section .text-content {
  padding-right: 40px;
}

.hero-section .subtitle {
  color: var(--red-high);
  font-size: 30px;
  font-weight: 550;
  margin-bottom: 20px;
  font-family: var(--ITC-clearface-Std);
  max-width: 500px;
}

.hero-section .main-heading {
  font-size: 102px;
  font-weight: 400;
  color: #000;
  margin: 0px;
  text-transform: uppercase;
  font-family: var(--headline-Gothic);
  line-height: 85px;
}

.coloured-text {
  color: var(--red-high) !important;
}

.hero-section .main-heading .highlight {
  color: #c41e3a;
}

.hero-section .description {
  font-size: 24px;
  color: var(--black);
  margin-bottom: 40px;
  font-weight: 400;
  font-family: var(--body-font);
  letter-spacing: -2px;
  max-width: 700px;
}

.hero-section .cta-button {
  display: inline-block;
  background: var(--blood-red);
  color: white;
  padding: 20px 110px 20px 20px;
  text-decoration: none;
  font-size: 16px;
  font-weight: 600;
  transition: all 0.3s ease;
  position: relative;
  overflow: hidden;
}

.hero-section .cta-button::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.1);
  transition: left 0.3s ease;
}

.hero-section .cta-button:hover::before {
  left: 0;
}

.hero-section .cta-label {
  font-size: 15px;
  display: block;
  font-family: var(--ITC-clearface-Std);
}

.hero-section .cta-phone {
  display: block;
  font-family: var(--headline-Gothic);
  font-size: 44px;
  font-weight: 500;
  text-decoration: none;
  display: block;
  transition: color 0.3s ease;
}

.hero-section .image-content {
  position: absolute;
  z-index: 2;
  border: 0;
  right: 0;
  bottom: 0;
}

.hero-section .lawyer-image {
  right: 0;
  bottom: 0;
  height: 100%;
  width: auto;
  object-fit: contain;
  z-index: 2;
  filter: drop-shadow(0 10px 30px rgba(0, 0, 0, 0.2));
  max-width: 950px;
  min-height: 950px !important;
}

.hero-section .lawyer-image {
  max-height: 100%;
}

.hero-section .decorative-flag {
  position: absolute;
  right: 0;
  bottom: 0;
  width: 700px;
  height: auto;
  z-index: 100;
  opacity: 0.95;
}
    </style>