<?php
// components/gsap-hover-section.php

// Get custom field values or use defaults
$section_title = get_field('gsap_section_title') ?: 'Text Effects Section';
$text_items = get_field('gsap_text_items') ?: [
    ['text' => 'TEXT EFFECT', 'overlay' => 'WOAH'],
    ['text' => 'GSAP', 'overlay' => 'AND'],
    ['text' => 'CRAZYYY', 'overlay' => 'CRAZYYY'],
    ['text' => 'HOVER ON ME', 'overlay' => 'SOURCE', 'link' => ''],
    ['text' => 'LIKE THIS?', 'overlay' => 'LET\'S CONNECT', 'link' => '']
];
$section_background = get_field('gsap_section_background') ?: '#fff';
$accent_color = get_field('gsap_accent_color') ?: '#e50914';
$border_radius = get_field('gsap_border_radius') ?: '8vw';
?>

<style>
.text-effects-section {
  background-color: <?php echo esc_attr($section_background); ?>;
  margin: 100px 20px;
  position: relative;
  overflow: hidden;
  border-top-left-radius: <?php echo esc_attr($border_radius); ?>;
}

.text-effects-container {
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: flex-start;
  
  max-width: 1200px;
  margin: 0 auto;
}

.animated-text {
  font-size: 7vw;
  letter-spacing: -.01em;
  line-height: 100%;
  margin: 0;
  width: 100%;
  color: rgba(0, 0, 0, 0.53);
  background: linear-gradient(to right, <?php echo esc_attr($accent_color); ?>, <?php echo esc_attr($accent_color); ?>) no-repeat;
  -webkit-background-clip: text;
  background-clip: text;
  background-size: 0%;
  transition: background-size cubic-bezier(.1,.5,.5,1) 0.5s;
  border-bottom: 1px solid #2F2B28;
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  justify-content: center;
  position: relative;
  cursor: pointer;
  padding: 0.5rem 0;
  text-decoration: none;
}

.text-overlay {
  position: absolute;
  width: 100%;
  height: 100%;
  background-color: <?php echo esc_attr($accent_color); ?>;
  color: #0D0D0D;
  clip-path: polygon(0 50%, 100% 50%, 100% 50%, 0 50%);
  transform-origin: center;
  transition: all cubic-bezier(.1,.5,.5,1) 0.4s;
  display: flex;
  flex-direction: column;
  justify-content: center;
  padding-left: 0.2em;
  box-sizing: border-box;
  text-decoration: none;
}

.animated-text:hover .text-overlay {
  clip-path: polygon(0 0, 100% 0, 100% 100%, 0% 100%);
}

.info-link {
  text-decoration: none;
  color: inherit;
  font-weight: bold;
}

/* Ensure proper text alignment */
.animated-text span {
  width: 100%;
}
</style>

<section class="text-effects-section">
  <div class="container">
    <div class="text-effects-container">
      <?php foreach($text_items as $item): ?>
        <h1 class="animated-text">
          <?php echo esc_html($item['text']); ?>
          <span class="text-overlay">
            <?php if(isset($item['link'])): ?>
              <a class="info-link" href="<?php echo esc_url($item['link']); ?>" target="_blank">
                <?php echo esc_html($item['overlay']); ?>
              </a>
            <?php else: ?>
              <?php echo esc_html($item['overlay']); ?>
            <?php endif; ?>
          </span>
        </h1>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<?php
// Enqueue GSAP scripts
function enqueue_gsap_scripts() {
    wp_enqueue_script('gsap', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js', array(), '3.12.2', true);
    wp_enqueue_script('gsap-scrolltrigger', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js', array('gsap'), '3.12.2', true);
}
add_action('wp_enqueue_scripts', 'enqueue_gsap_scripts');
?>

<script>
function initTextEffect() {
  // Check if GSAP and ScrollTrigger are available
  if (typeof gsap === 'undefined' || typeof ScrollTrigger === 'undefined') {
    console.error('GSAP or ScrollTrigger not loaded');
    return;
  }

  // Register the ScrollTrigger plugin
  gsap.registerPlugin(ScrollTrigger);

  // Initialize the scroll animation for each text element
  const textElements = gsap.utils.toArray('.animated-text');

  textElements.forEach(text => {
    gsap.to(text, {
      backgroundSize: '100%',
      ease: 'none',
      scrollTrigger: {
        trigger: text,
        start: 'center 80%',
        end: 'center 20%',
        scrub: true,
      },
    });
  });
}

// Call this function when the page loads and GSAP is ready
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initTextEffect);
} else {
  initTextEffect();
}
</script>