<?php
// components/hero.php
?>
<style>
.hero {
  background-color: #212121;
  border-bottom-right-radius: 15vw;
  position: relative;
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
}

.hero:before {
  content: "";
  background-color: #212121;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
}

.hero:after {
  content: "";
  background-color: #fff;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
  border-top-left-radius: 15vw;
}

.video-wrap {
  position: absolute;
  width: 100%;
  height: 100%;
  overflow: hidden;
  border-bottom-right-radius: 15vw;
  pointer-events: none;
}

#video-bg {
  position: absolute;
  width: 100%;
  height: 100%;
  min-width: 100%;
  background-position: center center;
  background-size: cover;
  object-fit: cover;
  transform: rotate(180deg);
}

.gradient-overlay {
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 50%;
  background: linear-gradient(to bottom, rgba(33,33,33,0) 0%, rgba(33,33,33,1) 50%);
  z-index: 1;
  border-bottom-right-radius: 15vw;
  pointer-events: none;
}

.hero-content {
  position: relative;
  text-align: center;
  z-index: 2;
  margin-bottom: 5rem;
}

.hero-title {
  font-size: 8vw;
  line-height: 1em;
  font-weight: 900;
  mix-blend-mode: difference;
  color: #fff;
  position: relative;
  z-index: 2;
}

/* Responsive styles */
@media (max-width: 992px) {
  .hero-title {
    font-size: 10vw;
  }
}

@media (max-width: 768px) {
  .hero-title {
    font-size: 12vw;
  }
  
  .hero {
    min-height: 80vh;
  }
}

@media (max-width: 576px) {
  .hero-title {
    font-size: 15vw;
  }
  
  .hero {
    min-height: 70vh;
  }
}
</style>

<section class="hero">
  <div class="video-wrap">
    <video autoplay playsinline loop muted id="video-bg">
      <source src="https://assets.codepen.io/319606/tactus-waves-hero-sm.mp4" type="video/mp4">
    </video>
  </div>
  <div class="position-absolute w-100 gradient-overlay"></div>
  <div class="content position-relative text-center mb-5">
    <h1 class="hero-title blend" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
      Where Creativity <br>
      &amp; Strategy Meet
    </h1>
  </div>
</section>