<?php
// components/home/globe-world-section.php
?>

<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<style>
    /* Your existing CSS styles here */
    .globe-world {
        background-color: #212121;
        background-image: url('https://images.unsplash.com/photo-1522071820081-009f0129c71c?ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&q=80&w=1170');
        background-size: cover;
        background-position: center;
        background-blend-mode: overlay;
        border-bottom-right-radius: 15vw;
        border-top-right-radius: 15vw;
        position: relative;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .globe-world:before {
        content: "";
        background-color: #212121;
        position: absolute;
        top: 100%;
        left: 0;
        width: 15vw;
        height: 15vw;
    }
    
    .globe-world:after {
        content: "";
        background-color: #fff;
        position: absolute;
        top: 100%;
        left: 0;
        width: 15vw;
        height: 15vw;
        border-top-left-radius: 15vw;
    }

    .wrapper-new {
        --total: 40;
        width: 40vw;
        aspect-ratio: 1;
        perspective: 80rem;
        transform-style: preserve-3d;
        position: relative;
    }

    .wrapper-new::after {
        content: "escope";
        position: absolute;
        inset: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 6vw;
        font-weight: 900;
        color: rgba(255, 255, 255, 0.342);
        letter-spacing: 0.5rem;
        z-index: -1;
    }

    .globe {
        position: relative;
        animation: spin 10s infinite linear;
        transform-style: preserve-3d;
        width: 100%;
        height: 100%;
    }

    .dot {
        --angle: calc(var(--i) * 360deg / var(--total));
        position: absolute;
        left: 0;
        top: 0;
        width: 40vw;
        aspect-ratio: 1;
        border: 3px dotted #e50914;
        border-radius: 50%;
        transform: rotateY(var(--angle)) rotateX(var(--angle));
    }

    @keyframes spin {
        to {
            transform: rotateY(360deg);
        }
    }

    /* AOS debug styles */
    [data-aos] {
        opacity: 1;
        transition: opacity 0.5s ease;
    }
    
    .aos-animate {
        opacity: 1 !important;
    }

    /* Responsive styles */
    @media screen and (max-width: 768px) {
        .wrapper-new {
            width: 60vw;
        }
        
        .dot {
            width: 60vw;
        }
    }

    @media screen and (max-width: 576px) {
        .wrapper-new {
            width: 80vw;
        }
        
        .dot {
            width: 80vw;
        }
        
        .wrapper-new::after {
            font-size: 8vw;
        }

        .globe-world {
            min-height: 60vh;
        }
    }
</style>

<!-- Globe World Section -->
<section class="globe-world py-5" data-aos="fade-up" data-aos-duration="600">
    <div class="container d-flex justify-content-center align-items-center">
        <div class="wrapper-new" data-aos="zoom-in" data-aos-delay="300" data-aos-duration="1000">
            <div class="globe">
                <!-- Generate 40 dots using PHP loop -->
                <?php for ($i = 0; $i < 40; $i++): ?>
                    <div class="dot" style="--i: <?php echo $i; ?>"></div>
                <?php endfor; ?>
            </div>
        </div>
    </div>
</section>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
    // Initialize AOS with more specific settings
    document.addEventListener('DOMContentLoaded', function() {
        console.log('Initializing AOS...');
        
        AOS.init({
            duration: 800,
            offset: 120,
            delay: 0,
            easing: 'ease',
            once: false,
            mirror: false,
            anchorPlacement: 'top-bottom',
            startEvent: 'DOMContentLoaded',
            disable: function() {
                var maxWidth = 768;
                return window.innerWidth < maxWidth;
            }
        });
        
        console.log('AOS initialized successfully');
        
        // Refresh AOS after a short delay to ensure all elements are loaded
        setTimeout(function() {
            AOS.refresh();
            console.log('AOS refreshed');
        }, 500);
    });

    // Also refresh on window load
    window.addEventListener('load', function() {
        AOS.refresh();
    });
</script>