<?php
// components/home/portfolio.php
?>
 <style>
 
    /* Portfolio Section Styles */
    .portfolio {
      background-color: #212121;
      border-bottom-right-radius: 15vw;
      border-top-right-radius: 15vw;
      position: relative;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 100px 0;
    }
    
    .portfolio:before {
      content: "";
      background-color: #212121;
      position: absolute;
      top: 100%;
      left: 0;
      width: 15vw;
      height: 15vw;
    }
    
    .portfolio:after {
      content: "";
      background-color: #fff;
      position: absolute;
      top: 100%;
      left: 0;
      width: 15vw;
      height: 15vw;
      border-top-left-radius: 15vw;
    }

    /* Video Background for Portfolio Section */
    .portfolio-video-wrap {
      position: absolute;
      width: 100%;
      height: 100%;
      overflow: hidden;
      border-bottom-right-radius: 15vw;
      border-top-right-radius: 15vw;
      pointer-events: none;
    }
    
    #portfolio-video-bg {
      position: absolute;
      width: 100%;
      height: 100%;
      min-width: 100%;
      background-position: center center;
      background-size: cover;
      object-fit: cover;
      opacity: 0.7;
    }
    
    .portfolio-gradient-overlay {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(to bottom, rgba(33,33,33,0.2) 0%, rgba(33,33,33,0.9) 100%);
      z-index: 1;
      border-bottom-right-radius: 15vw;
      border-top-right-radius: 15vw;
      pointer-events: none;
    }
    
    .portfolio-container {
      max-width: 1200px;
      margin: 0 auto;
      height: auto;
      position: relative;
      display: flex;
      flex-direction: column;
    }

    .portfolio-items {
      display: flex;
      flex-direction: column;
      align-items: center;
      width: 100%;
      flex: 1;
      justify-content: center;
      position: relative;
      overflow-y: auto;
      scrollbar-width: none;
      -ms-overflow-style: none;
      padding: 20px 0;
    }

    .portfolio-items::-webkit-scrollbar {
      display: none;
    }

    .portfolio-piece {
      width: 100%;
      text-align: center;
      cursor: pointer;
      margin-bottom: 1.5rem;
      position: relative;
      transition: all 0.3s ease;
    }

    .piece-title-wrapper {
      position: relative;
      display: inline-block;
      z-index: 5;
      pointer-events: auto;
      will-change: transform, opacity, filter;
    }

    .piece-title {
      font-size: 3rem;
      font-weight: 800;
      letter-spacing: -0.02em;
      margin: 0.5rem 0;
      color: #ffffff;
      transition: all 0.3s ease;
    }

    .hover-dot {
      position: absolute;
      width: 8px;
      height: 8px;
      background-color: #e50914;
      top: 50%;
      transform: translateY(-50%);
      opacity: 0;
      pointer-events: none;
      z-index: 100;
      will-change: width, opacity;
      border-radius: 50%;
      transition: all 0.3s ease;
    }

    .hover-dot.left {
      left: -20px;
    }

    .hover-dot.right {
      right: -20px;
    }

    .piece-expanded {
      display: flex;
      justify-content: space-between;
      align-items: center;
      max-height: 0;
      opacity: 0;
      overflow: hidden;
      padding: 0 1rem;
      margin: 0;
      pointer-events: none;
      transition: all 0.5s ease;
    }

    .piece-details {
      width: 25%;
      text-align: left;
      font-size: 0.8rem;
      letter-spacing: 0.05rem;
      font-weight: 500;
      color: #fff;
    }

    .piece-details .text-line {
      overflow: hidden;
      margin-bottom: 0.25rem;
    }

    .piece-details.right {
      text-align: right;
    }

    .detail-tag {
      margin-bottom: 0.25rem;
      font-size: 0.7rem;
      letter-spacing: 0.05rem;
      color: #fff;
      opacity: 0.8;
    }

    .detail-year {
      margin-top: 0.5rem;
      font-weight: 700;
      color: #e50914;
    }

    .piece-visual {
      width: 40%;
      max-width: 400px;
      position: relative;
      overflow: hidden;
      aspect-ratio: 4/3;
    }

    .visual-wrapper {
      position: relative;
      overflow: hidden;
      height: 100%;
      width: 100%;
      border-radius: 10px;
    }

    .visual-wrapper img {
      width: 100%;
      height: 100%;
      display: block;
      object-fit: cover;
      transition: transform 0.5s ease;
    }

    /* Active state for portfolio piece */
    .portfolio-piece.active .piece-expanded {
      max-height: 500px;
      opacity: 1;
      pointer-events: auto;
      margin: 2rem 0;
    }

    .portfolio-piece.active .piece-title {
      color: #e50914;
    }

    /* Section title */
    .section-title {
      font-size: 7.5rem;
      font-weight: 900;
      text-transform: uppercase;
      letter-spacing: -0.02em;
      text-align: center;
      margin-bottom: 60px;
      pointer-events: none;
      font-family: "Arial Black", "Arial Bold", Arial, sans-serif;
      background: linear-gradient(
        to bottom,
        rgba(229, 9, 20, 0.35) 30%,
        rgba(255, 255, 255, 0) 76%
      );
      -webkit-background-clip: text;
      background-clip: text;
      color: transparent;
    }

    /* Responsive styles */
    @media screen and (max-width: 992px) {
      .piece-expanded {
        flex-direction: column;
      }

      .piece-details {
        width: 100%;
        text-align: center;
        margin-bottom: 1rem;
      }

      .piece-details.right {
        text-align: center;
        margin-top: 1rem;
        margin-bottom: 0;
      }

      .piece-visual {
        width: 80%;
        margin: 1rem 0;
      }

      .piece-title {
        font-size: 2rem;
      }
    }

    @media screen and (max-width: 768px) {
      .portfolio {
        padding: 60px 0;
      }
      
      .section-title {
        font-size: 3.5rem;
      }
      
      .piece-title {
        font-size: 1.8rem;
      }

      .portfolio-piece {
        margin-bottom: 1rem;
      }
    }

    @media screen and (max-width: 576px) {
      .section-title {
        font-size: 3.0rem;
      }
      
      .piece-title {
        font-size: 1.5rem;
      }
    }

      .animated-text-new {
    font-size: 9vw;
    letter-spacing: -.01em;
    line-height: 100%;
    margin: 0;
    width: 100%;
    color: rgb(161 146 146);
    background: linear-gradient(to right, #e50914, #e50914) no-repeat;
    -webkit-background-clip: text;
    background-clip: text;
    background-size: 0%;
    transition: background-size cubic-bezier(.1,.5,.5,1) 0.5s;
    border-bottom: 1px solid #2F2B28;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    position: relative;
    cursor: pointer;
    padding: 0.5rem 0;
}
  </style>

  <!-- Portfolio Section -->
  <section class="portfolio">
    <!-- Video Background for Portfolio Section -->
    <div class="portfolio-video-wrap">
      <video autoplay playsinline loop muted id="portfolio-video-bg">
        <source src="https://assets.codepen.io/319606/tactus-waves-hero-sm.mp4" type="video/mp4">
      </video>
    </div>
    <div class="position-absolute w-100 portfolio-gradient-overlay"></div>
    
    <div class="container mt-5">
     <h1 class="animated-text-new mb-4" data-aos="fade-up" data-aos-duration="800">TEXT EFFECT<span class="text-overlay">WOAH</span></h1>
      <div class="portfolio-container">
        <div class="portfolio-items" data-index="0" data-aos="fade-up" data-aos-duration="800" data-aos-delay="100">
          <div class="portfolio-piece" data-index="0" data-aos="fade-up" data-aos-duration="800" data-aos-delay="100">
            <div class="piece-title-wrapper">
              <div class="hover-dot left"></div>
              <h2 class="piece-title">COSMIC DEPTHS</h2>
              <div class="hover-dot right"></div>
            </div>
            <div class="piece-expanded">
              <div class="piece-details left">
                <p class="detail-tag">SPATIAL AWARENESS</p>
                <p class="detail-tag">EXPANSIVE VISION</p>
                <p class="detail-tag">ETERNAL MOMENT</p>
              </div>
              <div class="piece-visual">
                <div class="visual-wrapper">
                  <img src="https://cdn.cosmos.so/2519c3a3-40c4-49ff-95ed-928b3cf69740?format=jpeg" alt="Cosmic depths image">
                </div>
              </div>
              <div class="piece-details right">
                <p class="detail-tag">SILENT OBSERVATION</p>
                <p class="detail-tag">TIMELESS CAPTURE</p>
                <p class="detail-tag">BEYOND PERCEPTION</p>
                <p class="detail-year">/2025</p>
              </div>
            </div>
          </div>

          <div class="portfolio-piece" data-index="1" data-aos="fade-up" data-aos-duration="800" data-aos-delay="200">
            <div class="piece-title-wrapper">
              <div class="hover-dot left"></div>
              <h2 class="piece-title">FOURTH DIMENSION</h2>
              <div class="hover-dot right"></div>
            </div>
            <div class="piece-expanded">
              <div class="piece-details left">
                <p class="detail-tag">TEMPORAL SHIFT</p>
                <p class="detail-tag">BEYOND LINEAR</p>
                <p class="detail-tag">QUANTUM SPACE</p>
              </div>
              <div class="piece-visual">
                <div class="visual-wrapper">
                  <img src="https://cdn.cosmos.so/17b5c6b8-91c7-420b-8b98-29ec22b1afbb?format=jpeg" alt="Fourth dimension image">
                </div>
              </div>
              <div class="piece-details right">
                <p class="detail-tag">TIME COLLAPSE</p>
                <p class="detail-tag">HYPERCUBE VISION</p>
                <p class="detail-tag">BEYOND LIMITS</p>
                <p class="detail-year">/2025</p>
              </div>
            </div>
          </div>

          <div class="portfolio-piece" data-index="2" data-aos="fade-up" data-aos-duration="800" data-aos-delay="300">
            <div class="piece-title-wrapper">
              <div class="hover-dot left"></div>
              <h2 class="piece-title">INNER VOID</h2>
              <div class="hover-dot right"></div>
            </div>
            <div class="piece-expanded">
              <div class="piece-details left">
                <p class="detail-tag">NEGATIVE SPACE</p>
                <p class="detail-tag">CONSCIOUS ABSENCE</p>
                <p class="detail-tag">SILENT DEPTH</p>
              </div>
              <div class="piece-visual">
                <div class="visual-wrapper">
                  <img src="https://cdn.cosmos.so/9ed5e53a-bc97-4f58-bbde-3c4590687eb7?format=jpeg" alt="Inner void image">
                </div>
              </div>
              <div class="piece-details right">
                <p class="detail-tag">CREATIVE EMPTINESS</p>
                <p class="detail-tag">QUANTUM POTENTIAL</p>
                <p class="detail-tag">ABSOLUTE STILLNESS</p>
                <p class="detail-year">/2025</p>
              </div>
            </div>
          </div>

          <div class="portfolio-piece" data-index="3" data-aos="fade-up" data-aos-duration="800" data-aos-delay="400">
            <div class="piece-title-wrapper">
              <div class="hover-dot left"></div>
              <h2 class="piece-title">PRESENT WITNESS</h2>
              <div class="hover-dot right"></div>
            </div>
            <div class="piece-expanded">
              <div class="piece-details left">
                <p class="detail-tag">AWARE PERCEPTION</p>
                <p class="detail-tag">PHOTOGRAPHIC TRUTH</p>
                <p class="detail-tag">ESSENTIAL SEEING</p>
              </div>
              <div class="piece-visual">
                <div class="visual-wrapper">
                  <img src="https://cdn.cosmos.so/29733ed0-b6cc-4991-8585-159f41f658a9?format=jpeg" alt="Present witness image">
                </div>
              </div>
              <div class="piece-details right">
                <p class="detail-tag">SUSPENDED MOMENT</p>
                <p class="detail-tag">DISTILLED REALITY</p>
                <p class="detail-tag">INFINITE FRAME</p>
                <p class="detail-year">/2025</p>
              </div>
            </div>
          </div>

          <div class="portfolio-piece" data-index="4" data-aos="fade-up" data-aos-duration="800" data-aos-delay="500">
            <div class="piece-title-wrapper">
              <div class="hover-dot left"></div>
              <h2 class="piece-title">CREATIVE FLOW</h2>
              <div class="hover-dot right"></div>
            </div>
            <div class="piece-expanded">
              <div class="piece-details left">
                <p class="detail-tag">CHANNELED INSIGHT</p>
                <p class="detail-tag">BEYOND THOUGHT</p>
                <p class="detail-tag">PURE EXPRESSION</p>
              </div>
              <div class="piece-visual">
                <div class="visual-wrapper">
                  <img src="https://cdn.cosmos.so/2519c3a3-40c4-49ff-95ed-928b3cf69740?format=jpeg" alt="Creative flow image">
                </div>
              </div>
              <div class="piece-details right">
                <p class="detail-tag">TIMELESS STATE</p>
                <p class="detail-tag">DIRECT CONNECTION</p>
                <p class="detail-tag">SOURCE ALIGNMENT</p>
                <p class="detail-year">/2025</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Initialize AOS
      AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: false, 
        mirror: true
      });
      
      // Initialize portfolio functionality
      initPortfolio();
    });

    function initPortfolio() {
      const portfolioPieces = document.querySelectorAll('.portfolio-piece');
      let activePiece = null;
      
      // Set initial state
      portfolioPieces.forEach(piece => {
        piece.style.opacity = '0';
        piece.style.transform = 'translateY(20px)';
      });
      
      // Animate in portfolio pieces
      setTimeout(() => {
        portfolioPieces.forEach((piece, index) => {
          setTimeout(() => {
            piece.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            piece.style.opacity = '1';
            piece.style.transform = 'translateY(0)';
          }, index * 100);
        });
      }, 500);
      
      // Add click event listeners
      portfolioPieces.forEach(piece => {
        piece.addEventListener('click', function() {
          // If clicking the same piece, close it
          if (activePiece === this) {
            this.classList.remove('active');
            activePiece = null;
            return;
          }
          
          // Remove active class from previously active piece
          if (activePiece) {
            activePiece.classList.remove('active');
          }
          
          // Add active class to clicked piece
          this.classList.add('active');
          activePiece = this;
          
          // Scroll to make the active piece visible
          this.scrollIntoView({ behavior: 'smooth', block: 'center' });
        });
      });
      
      // Add hover effects for dots
      portfolioPieces.forEach(piece => {
        const titleWrapper = piece.querySelector('.piece-title-wrapper');
        const leftDot = piece.querySelector('.hover-dot.left');
        const rightDot = piece.querySelector('.hover-dot.right');
        
        titleWrapper.addEventListener('mouseenter', () => {
          if (!piece.classList.contains('active')) {
            leftDot.style.opacity = '1';
            rightDot.style.opacity = '1';
            leftDot.style.transform = 'translateY(-50%) translateX(-15px)';
            rightDot.style.transform = 'translateY(-50%) translateX(15px)';
          }
        });
        
        titleWrapper.addEventListener('mouseleave', () => {
          if (!piece.classList.contains('active')) {
            leftDot.style.opacity = '0';
            rightDot.style.opacity = '0';
            leftDot.style.transform = 'translateY(-50%) translateX(-10px)';
            rightDot.style.transform = 'translateY(-50%) translateX(10px)';
          }
        });
      });
    }
  </script>