<?php
// components/slider-4.php
?>
    <style>
.carousel-section {
    height: 100vh;
    display: grid;
    place-items: center;
    overflow: hidden;
    position: relative;
    border-bottom-right-radius: 15vw;
    border-top-right-radius: 15vw;
}

.carousel-section main {
    position: relative;
    width: 100%;
    height: 100%;
    box-shadow: 0 3px 10px rgba(0,0,0,0.3);
}

.carousel-section .slider {
    width: 100%;
    height: 100%;
    position: relative;
}

.carousel-section .item {
    width: 200px;
    height: 300px;
    list-style-type: none;
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    z-index: 1;
    background-position: center;
    background-size: cover;
    border-radius: 20px;
    box-shadow: 0 20px 30px rgba(255,255,255,0.3) inset;
    transition: transform 0.1s, left 0.75s, top 0.75s, width 0.75s, height 0.75s;
}

.carousel-section .item:nth-child(1), .carousel-section .item:nth-child(2) {
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    transform: none;
    border-radius: 0;
    box-shadow: none;
    opacity: 1;
}

.carousel-section .item:nth-child(3) { left: 50%; }
.carousel-section .item:nth-child(4) { left: calc(50% + 220px); }
.carousel-section .item:nth-child(5) { left: calc(50% + 440px); }
.carousel-section .item:nth-child(6) { left: calc(50% + 660px); opacity: 0; }

.carousel-section .content {
    width: min(30vw,400px);
    position: absolute;
    top: 50%;
    left: 3rem;
    transform: translateY(-50%);
    font: 400 0.85rem helvetica,sans-serif;
    color: white;
    text-shadow: 0 3px 8px rgba(0,0,0,0.5);
    opacity: 0;
    display: none;
}

.carousel-section .content .title {
    font-family: 'arial-black';
    text-transform: uppercase;
}

.carousel-section .content .description {
    line-height: 1.7;
    margin: 1rem 0 1.5rem;
    font-size: 0.8rem;
}

.carousel-section .content button {
    width: fit-content;
    background-color: rgba(0,0,0,0.1);
    color: white;
    border: 2px solid white;
    border-radius: 0.25rem;
    padding: 0.75rem;
    cursor: pointer;
}

.carousel-section .item:nth-of-type(2) .content {
    display: block;
    animation: show 0.75s ease-in-out 0.3s forwards;
}

@keyframes show {
    0% {
        filter: blur(5px);
        transform: translateY(calc(-50% + 75px));
    }
    100% {
        opacity: 1;
        filter: blur(0);
    }
}

.carousel-section .nav {
    position: absolute;
    bottom: 2rem;
    left: 50%;
    transform: translateX(-50%);
    z-index: 5;
    user-select: none;
}

.carousel-section .nav .btn {
    background-color: #ffffffff;
    color:#e50914;
    border: 2px solid #e50914;
    margin: 0 0.25rem;
    padding: 0.75rem;
    border-radius: 50%;
    cursor: pointer;
}

.carousel-section .nav .btn:hover {
    background-color: rgba(255,255,255,0.3);
}

@media (width > 650px) and (width < 900px) {
    .carousel-section .content .title { font-size: 1rem; }
    .carousel-section .content .description { font-size: 0.7rem; }
    .carousel-section .content button { font-size: 0.7rem; }
    .carousel-section .item {
        width: 160px;
        height: 270px;
    }
    .carousel-section .item:nth-child(3) { left: 50%; }
    .carousel-section .item:nth-child(4) { left: calc(50% + 170px); }
    .carousel-section .item:nth-child(5) { left: calc(50% + 340px); }
    .carousel-section .item:nth-child(6) { left: calc(50% + 510px); opacity: 0; }
}

@media (width < 650px) {
    .carousel-section .content .title { font-size: 0.9rem; }
    .carousel-section .content .description { font-size: 0.65rem; }
    .carousel-section .content button { font-size: 0.7rem; }
    .carousel-section .item {
        width: 130px;
        height: 220px;
    }
    .carousel-section .item:nth-child(3) { left: 50%; }
    .carousel-section .item:nth-child(4) { left: calc(50% + 140px); }
    .carousel-section .item:nth-child(5) { left: calc(50% + 280px); }
    .carousel-section .item:nth-child(6) { left: calc(50% + 420px); opacity: 0; }
}
    </style>

     <section class="carousel-section" id="carousel-section-4">
    <main>
        <?php if (have_rows('carousel_slides')): ?>
            <ul class='slider'>
                <?php 
                $slide_count = 0;
                while (have_rows('carousel_slides')): the_row(); 
                    $slide_count++;
                    $image = get_sub_field('slide_image');
                    $title = get_sub_field('slide_title');
                    $description = get_sub_field('slide_description');
                    $button_text = get_sub_field('slide_button_text');
                    $button_link = get_sub_field('slide_button_link');
                ?>
                    <li class='item' style="background-image: url('<?php echo esc_url($image); ?>')">
                        <div class='content'>
                            <h2 class='title'><?php echo esc_html($title); ?></h2>
                            <p class='description'><?php echo esc_html($description); ?></p>
                            <?php if ($button_text && $button_link): ?>
                                <a href="<?php echo esc_url($button_link); ?>">
                                    <button><?php echo esc_html($button_text); ?></button>
                                </a>
                            <?php endif; ?>
                        </div>
                    </li>
                <?php endwhile; ?>
            </ul>
            
            <?php if ($slide_count > 1): ?>
                <nav class='nav'>
                    <ion-icon class='btn prev' name="arrow-back-outline"></ion-icon>
                    <ion-icon class='btn next' name="arrow-forward-outline"></ion-icon>
                </nav>
            <?php endif; ?>
        <?php else: ?>
            <p>No slides found. Please add slides in the WordPress admin.</p>
        <?php endif; ?>
    </main>
</section>
    <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>

    <script>
       // Carousel functionality for section 4
document.addEventListener('DOMContentLoaded', function() {
    const carouselSection = document.getElementById('carousel-section-4');
    if (!carouselSection) return;
    
    const slider = carouselSection.querySelector('.slider');
    
    function activate(e) {
        const items = carouselSection.querySelectorAll('.item');
        if (e.target.matches('.next')) {
            slider.append(items[0]);
        } else if (e.target.matches('.prev')) {
            slider.prepend(items[items.length-1]);
        }
    }
    
    // Only listen for clicks within this carousel section
    carouselSection.addEventListener('click', activate, false);
});
    </script>