<?php
// components/technology/technology-card.php

// Get ACF fields
$section_title = get_field('section_title') ?: 'TEXT EFFECT';
$technology_cards = get_field('technology_cards');

if ($technology_cards) :
?>
<section class="services-section min-h-screen bg-gray-900 text-center py-20 px-8 xl:px-0 flex flex-col justify-center globe-world">
  <div class="head">
    <h1 class="animated-text-new mb-4 aos-init aos-animate" data-aos="fade-up" data-aos-duration="800">
      <?php echo esc_html($section_title); ?><span class="text-overlay">WOAH</span>
    </h1>
  </div>
  
  <div class="services-section-grid text-left grid sm:grid-cols-2 md:grid-cols-2 gap-5 max-w-5xl mx-auto">
    <?php 
    $card_positions = [
      'lg:pr-52',
      'lg:pl-48', 
      'lg:pr-44',
      'lg:pl-48'
    ];
    
    $i = 0;
    foreach ($technology_cards as $card) : 
      $position_class = isset($card_positions[$i]) ? $card_positions[$i] : '';
      $i++;
    ?>
    <div class="services-section-card bg-gray-800 p-10 relative">
      <div class="services-section-circle">
        <?php if ($card['card_image']) : ?>
          <img src="<?php echo esc_url($card['card_image']); ?>" alt="<?php echo esc_attr($card['card_title']); ?>" style="display: none;">
        <?php endif; ?>
      </div>
      <div class="services-section-content relative <?php echo $position_class; ?>">
        <h2 class="services-section-card-title capitalize text-white mb-4 text-2xl xl:text-3xl">
          <?php echo nl2br(esc_html($card['card_title'])); ?>
        </h2>
        <p class="services-section-card-text text-gray-400">
          <?php echo esc_html($card['card_description']); ?>
        </p>
      </div>
      <div class="services-section-icon" data-icon="<?php echo esc_attr($card['card_icon']); ?>"></div>
    </div>
    <?php endforeach; ?>
  </div>
</section>

<style>
@import url("https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;1,400&display=swap");
@import url("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css");

/* Globe world background styles */
.services-section.globe-world {
  background-color: #212121;
  border-bottom-right-radius: 15vw;
  border-top-right-radius: 15vw;
  position: relative;
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
}

.services-section.globe-world:before {
  content: "";
  background-color: #212121;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
}

.services-section.globe-world:after {
  content: "";
  background-color: #fff;
  position: absolute;
  top: 100%;
  left: 0;
  width: 15vw;
  height: 15vw;
  border-top-left-radius: 15vw;
}

/* Scoped styles for the services section only */
.services-section {
  /* Layout styles */
  min-height: 100vh;
  text-align: center;
  padding: 5rem 2rem;
  display: flex;
  flex-direction: column;
  justify-content: center;
}

@media (min-width: 1280px) {
  .services-section {
    padding-left: 0;
    padding-right: 0;
  }
}

.services-section-grid {
  text-align: left;
  display: grid;
  grid-template-columns: repeat(1, minmax(0, 1fr));
  gap: 1.25rem;
  max-width: 64rem;
  margin: 0 auto;
}

@media (min-width: 640px) {
  .services-section-grid {
    grid-template-columns: repeat(2, minmax(0, 1fr));
  }
}

.services-section-card {
  position: relative;
  background-color: #fa000034;
  padding: 2.5rem;
  overflow: hidden;
  border-radius: 0.5rem;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.services-section-card:hover {
  transform: translateY(-5px);
  box-shadow: 0.063rem 0.063rem 1.25rem 0.375rem rgb(0 0 0 / 53%);
}

.services-section-card::before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  transition: 0.6s;
  z-index: 0;
  background-color: #e50914;
}

.services-section-card:nth-child(1)::before {
  bottom: 0;
  right: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 100% 100%);
}

.services-section-card:nth-child(2)::before {
  bottom: 0;
  left: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 0% 100%);
}

.services-section-card:nth-child(3)::before {
  top: 0;
  right: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 100% 0%);
}

.services-section-card:nth-child(4)::before {
  top: 0;
  left: 0;
  clip-path: circle(calc(6.25rem + 7.5vw) at 0% 0%);
}

.services-section-card:hover::before {
  clip-path: circle(110vw at 100% 100%);
}

.services-section-content {
  position: relative;
  z-index: 1;
}

@media (min-width: 1024px) {
  .services-section-card:nth-child(1) .services-section-content {
    padding-right: 13rem;
  }
  
  .services-section-card:nth-child(2) .services-section-content {
    padding-left: 12rem;
  }
  
  .services-section-card:nth-child(3) .services-section-content {
    padding-right: 11rem;
  }
  
  .services-section-card:nth-child(4) .services-section-content {
    padding-left: 12rem;
  }
}

.services-section-card-title {
  font-family: "Playfair Display", serif;
  font-optical-sizing: auto;
  font-weight: 400;
  font-style: normal;
  color: #ffffff;
  text-transform: capitalize;
  margin-bottom: 1rem;
  font-size: 1.5rem;
}

@media (min-width: 1280px) {
  .services-section-card-title {
    font-size: 1.875rem;
  }
}

.services-section-card-text {
  color: #9ca3af;
  transition: 0.8s;
  position: relative;
  z-index: 1;
}

.services-section-card:hover .services-section-card-text {
  color: #fff;
}

.services-section-circle {
  display: none;
}

@media (min-width: 62.5rem) {
  .services-section-circle {
    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 0;
    display: block;
  }
}

/* Dynamic background images for cards */
<?php 
$j = 0;
foreach ($technology_cards as $card) : 
  $j++;
  if ($card['card_image']) :
?>
.services-section-card:nth-child(<?php echo $j; ?>) .services-section-circle {
  background: url("<?php echo esc_url($card['card_image']); ?>") no-repeat 50% 50% / cover;
  <?php 
  // Set clip-path based on card position
  if ($j == 1) echo 'bottom: 0; right: 0; clip-path: circle(calc(6.25rem + 7.5vw) at 100% 100%);';
  elseif ($j == 2) echo 'bottom: 0; left: 0; clip-path: circle(calc(6.25rem + 7.5vw) at 0% 100%);';
  elseif ($j == 3) echo 'top: 0; right: 0; clip-path: circle(calc(6.25rem + 7.5vw) at 100% 0%);';
  elseif ($j == 4) echo 'top: 0; left: 0; clip-path: circle(calc(6.25rem + 7.5vw) at 0% 0%);';
  ?>
}
<?php 
  endif;
endforeach; 
?>

.services-section-icon {
  position: absolute;
  bottom: 2rem;
  right: 2rem;
  font-size: 2rem;
  color: #e50914;
  z-index: 1;
  transition: transform 0.3s ease;
}

.services-section-card:hover .services-section-icon {
  transform: scale(1.1);
}

/* Dynamic icons based on ACF selection */
<?php 
$k = 0;
foreach ($technology_cards as $card) : 
  $k++;
  $icon_content = '';
  
  switch($card['card_icon']) {
    case 'ui_ux':
      $icon_content = '\\f53f'; // Font Awesome code for UI/UX
      break;
    case 'graphic':
      $icon_content = '\\f03e'; // Font Awesome code for images
      break;
    case 'marketing':
      $icon_content = '\\f201'; // Font Awesome code for marketing
      break;
    case 'business':
      $icon_content = '\\f062'; // Font Awesome code for growth
      break;
    default:
      $icon_content = '\\f0c9'; // Default icon
  }
?>
.services-section-card:nth-child(<?php echo $k; ?>) .services-section-icon::before {
  content: "<?php echo $icon_content; ?>";
  font-family: "Font Awesome 6 Free";
  font-weight: 900;
}
<?php endforeach; ?>

/* Responsive adjustments */
@media (max-width: 768px) {
  .services-section {
    padding: 3rem 1rem;
  }
  
  .services-section-card {
    padding: 1.5rem;
  }
}
</style>

<?php endif; ?>